/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.folders;

import com.lightcrafts.ui.browser.folders.FolderTreeNode;
import com.lightcrafts.ui.browser.folders.NodeFileIndex;
import com.lightcrafts.utils.directory.DirectoryListener;
import com.lightcrafts.utils.directory.DirectoryMonitor;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.tree.DefaultTreeModel;

class FolderTreeModel
extends DefaultTreeModel
implements DirectoryListener {
    private NodeFileIndex index;
    private DirectoryMonitor monitor;

    FolderTreeModel() {
        super(FolderTreeNode.createRoot());
        FolderTreeNode root = (FolderTreeNode)this.getRoot();
        this.index = root.getIndex();
        this.monitor = root.getDirectoryMonitor();
        this.monitor.addListener(this);
    }

    @Override
    public void directoryChanged(final File dir) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FolderTreeModel.this.directoryChanged(dir);
                }
            });
            return;
        }
        FolderTreeNode node = this.index.get(dir);
        if (node == null) {
            return;
        }
        if (dir.isDirectory()) {
            node.updateChildren();
            this.nodeStructureChanged(node);
        } else {
            FolderTreeNode parent = (FolderTreeNode)node.getParent();
            parent.updateChildren();
            this.nodeStructureChanged(parent);
        }
    }

    public void dispose() {
        this.monitor.removeListener(this);
        this.monitor.dispose();
    }

    DirectoryMonitor getDirectoryMonitor() {
        return this.monitor;
    }
}

