/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.folders;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.folders.FolderTreeCellRenderer;
import com.lightcrafts.ui.browser.folders.FolderTreeListener;
import com.lightcrafts.ui.browser.folders.FolderTreeModel;
import com.lightcrafts.ui.browser.folders.FolderTreeNode;
import com.lightcrafts.ui.browser.folders.FolderTreeSelectionModel;
import com.lightcrafts.ui.browser.folders.FolderTreeTransferHandler;
import java.awt.dnd.DropTarget;
import java.io.File;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

class FolderTree
extends JTree {
    private LinkedList<FolderTreeListener> listeners;

    FolderTree() {
        super(new FolderTreeModel());
        this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.setFocusable(false);
        TreeCellRenderer renderer = FolderTreeCellRenderer.createRenderer();
        this.setCellRenderer(renderer);
        FolderTreeTransferHandler trans = new FolderTreeTransferHandler(this);
        this.setTransferHandler(trans);
        FolderTreeSelectionModel selection = new FolderTreeSelectionModel(this);
        this.setSelectionModel(selection);
        DropTarget target = this.getDropTarget();
        try {
            target.addDropTargetListener(selection);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FolderTree.this.notifyFolderSelected();
            }
        });
        this.listeners = new LinkedList();
    }

    void addFolderTreeListener(FolderTreeListener listener) {
        this.listeners.add(listener);
    }

    void removeFolderTreeListener(FolderTreeListener listener) {
        this.listeners.remove(listener);
    }

    FolderTreeNode getRoot() {
        return (FolderTreeNode)this.getModel().getRoot();
    }

    boolean goToPicturesFolder() {
        String[] components = Platform.getPlatform().getPathComponentsToPicturesFolder();
        if (components == null || components.length == 0) {
            return false;
        }
        FolderTreeNode node = this.getRoot();
        for (String component : components) {
            boolean matchedComponent = false;
            Enumeration<FolderTreeNode> e = node.children();
            while (e.hasMoreElements()) {
                FolderTreeNode child = e.nextElement();
                if (!child.toString().equals(component)) continue;
                node = child;
                matchedComponent = true;
                break;
            }
            if (matchedComponent) continue;
            return false;
        }
        this.setSelectionPath(node.getTreePath());
        return true;
    }

    void notifyDropAccepted(List<File> files, File folder) {
        for (FolderTreeListener listener : this.listeners) {
            listener.folderDropAccepted(files, folder);
        }
    }

    void notifyFolderSelected() {
        FolderTreeNode node = this.getSelectedNode();
        if (node != null) {
            File file = node.getFile();
            for (FolderTreeListener listener : this.listeners) {
                listener.folderSelectionChanged(file);
            }
        }
    }

    FolderTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            FolderTreeNode node = (FolderTreeNode)path.getLastPathComponent();
            return node;
        }
        return null;
    }

    void dispose() {
        FolderTreeModel model = (FolderTreeModel)this.getModel();
        model.dispose();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

