/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.ctrls;

import com.lightcrafts.ui.browser.ctrls.ButtonFactory;
import com.lightcrafts.ui.browser.ctrls.Locale;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.toolkit.ImageOnlyButton;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JToggleButton;

class SortUpDownCtrl
extends JToggleButton
implements ItemListener {
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/browser/ctrls");
    private static final String InvertedKey = "SortInverted";
    private static final Icon UpIcon = ButtonFactory.getIconByName("sort_up");
    private static final Icon DownIcon = ButtonFactory.getIconByName("sort_down");
    private AbstractImageBrowser images;

    SortUpDownCtrl(AbstractImageBrowser images) {
        this.images = images;
        this.setIcon(DownIcon);
        this.setToolTipText(Locale.LOCALE.get("SortUpToolTip"));
        ImageOnlyButton.setStyle(this);
        this.addItemListener(this);
        boolean inverted = Prefs.getBoolean(InvertedKey, false);
        if (inverted) {
            this.setSelected(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        boolean selected = event.getStateChange() == 1;
        this.images.setSortInverted(selected);
        if (selected) {
            this.setToolTipText(Locale.LOCALE.get("SortDownToolTip"));
            this.setIcon(UpIcon);
        } else {
            this.setToolTipText(Locale.LOCALE.get("SortUpToolTip"));
            this.setIcon(DownIcon);
        }
        Prefs.putBoolean(InvertedKey, selected);
    }
}

