/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.ctrls;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.prefs.ApplicationMode;
import com.lightcrafts.ui.browser.ctrls.ButtonFactory;
import com.lightcrafts.ui.browser.ctrls.Locale;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.ImageBrowserActions;
import com.lightcrafts.ui.toolkit.CoolButton;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class RatingButton
extends CoolButton {
    private static final String ToolTip = Locale.LOCALE.get("RateButtonToolTip");
    private static final Icon starIcon = ButtonFactory.getIconByName("star");
    private JPopupMenu popup;

    public RatingButton(AbstractImageBrowser browser) {
        this.setIcon(starIcon);
        this.setToolTipText(ToolTip);
        ApplicationMode.maybeSetToolTip(this);
        this.popup = new JPopupMenu();
        ImageBrowserActions actions = browser.getActions();
        List<Action> rateActions = actions.getRatingActions();
        for (Action rateAction : rateActions) {
            JMenuItem item = new JMenuItem(rateAction);
            if (Platform.getType() == Platform.Windows) {
                item.setFont(new Font("Serif", 0, 14));
            }
            item.setAccelerator(null);
            this.popup.add(item);
        }
        this.popup.addSeparator();
        Action clearAction = actions.getClearRatingAction();
        JMenuItem item = new JMenuItem(clearAction);
        item.setAccelerator(null);
        this.popup.add(item);
        if (!ApplicationMode.isBasicMode()) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    Dimension size = RatingButton.this.getSize();
                    RatingButton.this.popup.show(RatingButton.this, 0, size.height);
                }
            });
        }
        clearAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String propName = event.getPropertyName();
                if (propName.equals("enabled")) {
                    boolean enabled = (Boolean)event.getNewValue();
                    RatingButton.this.setEnabled(enabled);
                    RatingButton.this.repaint();
                }
            }
        });
        this.setEnabled(clearAction.isEnabled());
    }
}

