/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.ctrls;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.ctrls.Locale;
import com.lightcrafts.ui.browser.folders.FolderBrowserPane;
import com.lightcrafts.ui.browser.folders.FolderTreeListener;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import com.lightcrafts.ui.toolkit.MenuButton;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class NavigationButtons
extends JPanel {
    private static Icon ImgFwd = IconFactory.createInvertedIcon(NavigationButtons.class, "forward.png");
    private static Icon ImgBack = IconFactory.createInvertedIcon(NavigationButtons.class, "back.png");
    private static Icon imgPath;
    private FolderBrowserPane browser;
    private JButton btnBack;
    private JButton btnForward;
    private MenuButton btnPath;

    public NavigationButtons(FolderBrowserPane browser) {
        this.browser = browser;
        this.setOpaque(true);
        this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.createComponents();
        this.initComponents();
        this.plumbComponents();
        this.layoutComponents();
        this.setMaximumSize(new Dimension(1000, this.btnPath.getHeight() + 4));
    }

    private void createComponents() {
        this.btnBack = new CoolButton();
        this.btnForward = new CoolButton();
        this.btnPath = this.browser.getPathPopupMenu();
    }

    private void initComponents() {
        this.btnBack.setIcon(ImgBack);
        this.btnBack.setToolTipText(Locale.LOCALE.get("BackToolTip"));
        this.btnBack.setEnabled(false);
        this.btnForward.setIcon(ImgFwd);
        this.btnForward.setToolTipText(Locale.LOCALE.get("ForwardToolTip"));
        this.btnForward.setEnabled(false);
        this.btnPath.setIcon(imgPath);
        this.btnPath.putClientProperty("substancelaf.componentFlat", Boolean.FALSE);
        this.btnPath.setToolTipText(Locale.LOCALE.get("PathToolTip"));
    }

    private void plumbComponents() {
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationButtons.this.browser.goBack();
            }
        });
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationButtons.this.browser.goForward();
            }
        });
        this.browser.addSelectionListener(new FolderTreeListener(){

            @Override
            public void folderSelectionChanged(File folder) {
                NavigationButtons.this.btnBack.setEnabled(NavigationButtons.this.browser.isBackAvailable());
                NavigationButtons.this.btnForward.setEnabled(NavigationButtons.this.browser.isForwardAvailable());
            }

            @Override
            public void folderDropAccepted(List<File> files, File folder) {
            }
        });
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 0));
        Border border = BorderFactory.createEmptyBorder(3, 0, 3, 0);
        this.setBorder(border);
        this.add(Box.createHorizontalStrut(8));
        this.add(this.btnBack);
        this.add(this.btnForward);
        this.add(Box.createHorizontalStrut(8));
        this.add(this.btnPath);
        this.add(Box.createHorizontalStrut(8));
        this.add(Box.createHorizontalGlue());
    }

    static {
        try {
            imgPath = new ImageIcon(ImageIO.read(NavigationButtons.class.getResource("resources/path.png")));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't initialize NavigationButtons", e);
        }
    }
}

