/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.ctrls;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.ctrls.NavigationPane;
import com.lightcrafts.ui.browser.folders.FolderBrowserPane;
import com.lightcrafts.ui.browser.folders.FolderTreeListener;
import com.lightcrafts.utils.directory.DirectoryMonitor;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class FolderCtrl
extends JPanel {
    private FolderBrowserPane tree;

    public FolderCtrl() {
        this.setLayout(new BoxLayout(this, 1));
        this.tree = new FolderBrowserPane();
        NavigationPane buttons = new NavigationPane(this.tree);
        this.add(buttons);
        this.add(this.tree);
        this.setBorder(LightZoneSkin.getPaneBorder());
    }

    public File getSelection() {
        return this.tree.getSelectedFile();
    }

    public boolean goToPicturesFolder() {
        return this.tree.goToPicturesFolder();
    }

    public void addSelectionListener(FolderTreeListener listener) {
        this.tree.addSelectionListener(listener);
    }

    public void removeSelectionListener(FolderTreeListener listener) {
        this.tree.removeSelectionListener(listener);
    }

    public JComponent getTree() {
        return this.tree;
    }

    public void horizontalMouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() >= 2 && this.tree.isWheelScrollingEnabled()) {
            JScrollBar bar = this.tree.getHorizontalScrollBar();
            int dir = e.getWheelRotation() < 0 ? -1 : 1;
            int inc = bar.getUnitIncrement(dir);
            int value = bar.getValue() - e.getWheelRotation() * inc;
            bar.setValue(value);
        }
    }

    public void dispose() {
        this.tree.dispose();
    }

    public void pauseFolderMonitor() {
        DirectoryMonitor monitor = this.tree.getDirectoryMonitor();
        monitor.suspend();
    }

    public void resumeFolderMonitor() {
        DirectoryMonitor monitor = this.tree.getDirectoryMonitor();
        monitor.resume(false);
    }

    public void restorePath(String key) {
        this.tree.restorePath(key);
    }

    public void savePath(String key) {
        this.tree.savePath(key);
    }
}

