/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.advice;

import com.lightcrafts.ui.advice.Advice;
import com.lightcrafts.ui.advice.CloseButton;
import com.lightcrafts.ui.advice.UnclickableTextArea;
import com.lightcrafts.ui.toolkit.TextAreaFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

class AdviceContent
extends JPanel {
    private static final Color TextColor = Color.white;
    private static final Color Background = new Color(88, 88, 88);
    private static final float TextFontSize = 11.0f;
    private static final Border Border = BorderFactory.createEmptyBorder(6, 2, 6, 8);
    private UnclickableTextArea message;
    private JButton button;
    private Box buttonBox;
    private Component strut;

    AdviceContent(Advice advice) {
        String text = advice.getMessage();
        JTextArea textArea = TextAreaFactory.createTextArea(text, 20);
        textArea.setEditable(false);
        textArea.setBorder(null);
        textArea.setForeground(TextColor);
        textArea.setBackground(Background);
        this.message = new UnclickableTextArea(textArea);
        Font font = this.message.getFont();
        font = font.deriveFont(11.0f);
        this.message.setFont(font);
        this.button = new CloseButton();
        this.button.setAlignmentY(0.0f);
        this.buttonBox = Box.createVerticalBox();
        this.buttonBox.add(this.button);
        this.buttonBox.add(Box.createVerticalGlue());
        this.strut = Box.createHorizontalStrut(8);
        this.setOpaque(true);
        this.setBackground(Background);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.buttonBox);
        this.add(this.strut);
        this.add(this.message);
        this.setBorder(Border);
        this.addDisposeListener();
    }

    void setCursorRecurse(Cursor cursor) {
        this.buttonBox.setCursor(cursor);
        this.strut.setCursor(cursor);
        this.message.setCursor(cursor);
        this.button.setCursor(Cursor.getDefaultCursor());
    }

    void addMouseInputListenerRecurse(MouseInputListener listener) {
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.message.addMouseInputListenerRecurse(listener);
    }

    private void addDisposeListener() {
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, AdviceContent.this.button);
                if (dialog != null) {
                    dialog.dispose();
                }
            }
        });
    }
}

