/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui;

import com.lightcrafts.mediax.jai.IHSColorSpace;
import contrib.com.jgoodies.looks.common.FontPolicy;
import contrib.com.jgoodies.looks.common.FontSet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import org.jvnet.substance.SubstanceButtonUI;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceToggleButtonUI;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;
import org.jvnet.substance.painter.GlassGradientPainter;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.skin.SubstanceSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceEbonyTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.ArcHeaderPainter;
import org.jvnet.substance.watermark.SubstanceNoneWatermark;

public class LightZoneSkin
extends SubstanceAbstractSkin {
    public static String NAME = "LightZone";
    public static final SubstanceTheme orangeTheme = LightZoneSkin.makeTheme((ColorScheme)new CustomColorScheme(Colors.LZOrange), "Orange");
    public static final FontSet fontSet = new LightZoneFontSet();
    private static final RenderingHints aliasingRenderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    static Color relight(Color color, float amount) {
        IHSColorSpace ihs = IHSColorSpace.getInstance();
        float[] components = new float[3];
        components = ihs.fromRGB(color.getColorComponents(components));
        components[0] = components[0] * amount;
        components = ihs.toRGB(components);
        return new Color(components[0], components[1], components[2]);
    }

    public static SubstanceTheme makeTheme(ColorScheme colorScheme, String name) {
        SubstanceTheme activeTheme = new SubstanceTheme(colorScheme, name, SubstanceTheme.ThemeKind.DARK);
        SubstanceTheme basicTheme = new SubstanceEbonyTheme().tint(0.05);
        SubstanceTheme defaultTheme = basicTheme.shade(0.2);
        SubstanceTheme disabledTheme = basicTheme.shade(0.3);
        SubstanceTheme activeTitleTheme = defaultTheme;
        SubstanceComplexTheme theme = new SubstanceComplexTheme(name + " Theme", SubstanceTheme.ThemeKind.DARK, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
        theme.setNonActivePainter((SubstanceGradientPainter)new SimplisticSoftBorderReverseGradientPainter());
        theme.setSelectedTabFadeStart(0.4);
        theme.setSelectedTabFadeEnd(0.7);
        theme.setCellRendererBackgroundTheme((SubstanceTheme)new SubstanceEbonyTheme());
        return theme;
    }

    public LightZoneSkin() {
        SubstanceEbonyTheme activeTheme = new SubstanceEbonyTheme();
        SubstanceTheme defaultTheme = activeTheme.shade(0.2);
        SubstanceTheme disabledTheme = activeTheme.shade(0.3);
        SubstanceTheme activeTitleTheme = defaultTheme;
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.DARK, (SubstanceTheme)activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
        theme.setNonActivePainter((SubstanceGradientPainter)new SimplisticSoftBorderReverseGradientPainter());
        theme.setSelectedTabFadeStart(0.3);
        theme.setSelectedTabFadeEnd(0.6);
        theme.setCellRendererBackgroundTheme((SubstanceTheme)new SubstanceEbonyTheme());
        this.theme = theme;
        this.shaper = new ClassicButtonShaper();
        this.watermark = new SubstanceNoneWatermark();
        this.gradientPainter = new GlassGradientPainter();
        this.titlePainter = new ArcHeaderPainter();
        this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);
    }

    public String getDisplayName() {
        return NAME;
    }

    public static Border getImageBorder() {
        return LightZoneSkin.getPaneBorder();
    }

    public static Border getPaneBorder() {
        return new EtchedBorder(1, new Color(48, 48, 48), new Color(23, 23, 23));
    }

    public static LookAndFeel getLightZoneLookAndFeel() {
        LightZoneLookAndFeel substance = new LightZoneLookAndFeel();
        LightZoneLookAndFeel.setSkin((SubstanceSkin)new LightZoneSkin());
        FontPolicy newFontPolicy = new FontPolicy(){

            public FontSet getFontSet(String lafName, UIDefaults table) {
                return new LightZoneFontSet();
            }
        };
        LightZoneLookAndFeel.setFontPolicy((FontPolicy)newFontPolicy);
        UIManager.put("substancelaf.noExtraElements", Boolean.TRUE);
        UIManager.put("ToolTip.backgroundInactive", ((LookAndFeel)((Object)substance)).getDefaults().get("ToolTip.background"));
        UIManager.put("ToolTip.foregroundInactive", ((LookAndFeel)((Object)substance)).getDefaults().get("ToolTip.foreground"));
        return substance;
    }

    static {
        aliasingRenderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        aliasingRenderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public static class LightZoneLookAndFeel
    extends SubstanceLookAndFeel {
        protected void initClassDefaults(UIDefaults table) {
            super.initClassDefaults(table);
            Object[] uiDefaults = new Object[]{"ButtonUI", LightZoneButtonUI.class.getName(), "ToggleButtonUI", LightZoneToggleButtonUI.class.getName()};
            table.putDefaults(uiDefaults);
        }
    }

    public static class LightZoneToggleButtonUI
    extends SubstanceToggleButtonUI {
        public static ComponentUI createUI(JComponent b) {
            AbstractButton button = (AbstractButton)b;
            button.setRolloverEnabled(true);
            button.setFocusable(false);
            button.setFocusPainted(false);
            return new LightZoneToggleButtonUI();
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHints(aliasingRenderHints);
            super.paint(graphics, jComponent);
        }

        public void installDefaults(AbstractButton b) {
            super.installDefaults(b);
            b.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        }
    }

    public static class LightZoneButtonUI
    extends SubstanceButtonUI {
        public static ComponentUI createUI(JComponent b) {
            AbstractButton button = (AbstractButton)b;
            button.setRolloverEnabled(true);
            button.setOpaque(false);
            button.setFocusable(false);
            button.setFocusPainted(false);
            return new LightZoneButtonUI();
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHints(aliasingRenderHints);
            super.paint(graphics, jComponent);
        }

        public void installDefaults(AbstractButton b) {
            super.installDefaults(b);
            b.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        }
    }

    public static class LightZoneFontSet
    implements FontSet {
        FontUIResource controlFont = new FontUIResource(this.fontFamily, 1, 11);
        FontUIResource menuFont = new FontUIResource("Arial", 0, 11);
        FontUIResource titleFont = new FontUIResource(this.fontFamily, 1, 9);
        FontUIResource windowTitleFont = new FontUIResource(this.fontFamily, 1, 14);
        FontUIResource smallFont = new FontUIResource(this.fontFamily, 0, 11);
        FontUIResource messageFont = new FontUIResource(this.fontFamily, 1, 11);
        String fontFamily = "Verdana";

        public FontUIResource getControlFont() {
            return this.controlFont;
        }

        public FontUIResource getMenuFont() {
            return this.menuFont;
        }

        public FontUIResource getTitleFont() {
            return this.titleFont;
        }

        public FontUIResource getWindowTitleFont() {
            return this.windowTitleFont;
        }

        public FontUIResource getSmallFont() {
            return this.smallFont;
        }

        public FontUIResource getMessageFont() {
            return this.messageFont;
        }
    }

    public static class CustomColorScheme
    extends BaseColorScheme {
        private final Color mainUltraLightColor;
        private final Color mainExtraLightColor;
        private final Color mainLightColor;
        private final Color mainMidColor;
        private final Color mainDarkColor;
        private final Color mainUltraDarkColor;
        private final Color foregroundColor;

        public CustomColorScheme(Color baseColor) {
            this.mainUltraLightColor = LightZoneSkin.relight(baseColor, 0.95f);
            this.mainExtraLightColor = LightZoneSkin.relight(baseColor, 0.85f);
            this.mainLightColor = LightZoneSkin.relight(baseColor, 0.7f);
            this.mainMidColor = LightZoneSkin.relight(baseColor, 0.6f);
            this.mainDarkColor = LightZoneSkin.relight(baseColor, 0.5f);
            this.mainUltraDarkColor = LightZoneSkin.relight(baseColor, 0.4f);
            this.foregroundColor = Color.white;
        }

        public Color getForegroundColor() {
            return this.foregroundColor;
        }

        public Color getUltraLightColor() {
            return this.mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return this.mainExtraLightColor;
        }

        public Color getLightColor() {
            return this.mainLightColor;
        }

        public Color getMidColor() {
            return this.mainMidColor;
        }

        public Color getDarkColor() {
            return this.mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return this.mainUltraDarkColor;
        }
    }

    public static class Colors {
        public static final Color NeutralGray;
        public static final Color EditorBackground;
        public static final Color FrameBackground;
        public static final Color ToolPanesBackground;
        public static final Color LabelForeground;
        public static final Color ToolsBackground;
        public static final Color ToolTitleTextColor;
        public static final Color ToolPanesForeground;
        public static final Color BrowserBackground;
        public static final Color BrowserSelectHighlight;
        public static final Color BrowserLabelBackground;
        public static final Color BrowserLabelForeground;
        public static final Color BrowserGroupColor;
        public static final Color BrowserImageTypeLabelBackground;
        public static final Color LZOrange;
        public static final Color SelectedToolBorder;

        static {
            float[] comps = ColorSpace.getInstance(1000).fromCIEXYZ(ColorSpace.getInstance(1004).toCIEXYZ(new float[]{0.18f, 0.18f, 0.18f}));
            NeutralGray = new Color(comps[0], comps[0], comps[0]);
            Color temp = NeutralGray.darker();
            BrowserImageTypeLabelBackground = new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), 128);
            EditorBackground = NeutralGray.darker();
            FrameBackground = new Color(28, 28, 28);
            ToolPanesBackground = new Color(62, 62, 62);
            LabelForeground = new Color(229, 229, 229);
            ToolsBackground = ToolPanesBackground;
            ToolTitleTextColor = LabelForeground;
            ToolPanesForeground = LabelForeground;
            BrowserBackground = NeutralGray.darker();
            BrowserSelectHighlight = new Color(188, 188, 154);
            BrowserLabelBackground = new Color(38, 38, 38);
            BrowserLabelForeground = LabelForeground;
            BrowserGroupColor = Color.gray;
            LZOrange = new Color(254, 155, 14);
            SelectedToolBorder = LightZoneSkin.relight(LZOrange, 0.7f);
        }
    }
}

