/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.templates;

import com.lightcrafts.templates.TemplateDatabase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class TemplateDeployer {
    private static boolean hasDeployed;

    TemplateDeployer() {
    }

    static void deploy() {
        Collection<String> templates = TemplateDeployer.getPredefinedTemplateNames();
        for (String template : templates) {
            try {
                TemplateDeployer.migrateTemplate(template);
            }
            catch (IOException e) {
                System.out.println("Failed to migrate template " + template);
                e.printStackTrace();
            }
        }
        hasDeployed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void migrateTemplate(String template) throws IOException {
        File dir = TemplateDatabase.TemplateDir;
        File file = new File(dir, template);
        ClassLoader loader = TemplateDeployer.class.getClassLoader();
        InputStream in = loader.getResourceAsStream("com/lightcrafts/templates/resources/" + template);
        if (in == null) {
            throw new IOException("Couldn't find resource for template " + template);
        }
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[10000];
        try {
            int count;
            do {
                if ((count = in.read(buffer)) <= 0) continue;
                ((OutputStream)out).write(buffer, 0, count);
            } while (count >= 0);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                System.out.println("Failed to close template " + template);
            }
        }
    }

    static boolean hasDeployed() {
        if (hasDeployed) {
            return true;
        }
        Collection<String> names = TemplateDeployer.getPredefinedTemplateNames();
        File dir = TemplateDatabase.TemplateDir;
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                String name = file.getName();
                names.remove(name);
            }
        }
        return names.isEmpty();
    }

    static Collection<String> getPredefinedTemplateNames() {
        String template;
        InputStream in = TemplateDeployer.class.getResourceAsStream("resources/TemplateList");
        if (in == null) {
            System.out.println("Couldn't access TemplateList");
            return Collections.emptySet();
        }
        InputStreamReader reader = new InputStreamReader(in);
        BufferedReader buffer = new BufferedReader(reader);
        ArrayList<String> names = new ArrayList<String>();
        do {
            try {
                template = buffer.readLine();
            }
            catch (IOException e) {
                System.out.println("Error reading TemplateList");
                e.printStackTrace();
                break;
            }
            if (template == null) continue;
            names.add(template);
        } while (template != null);
        return names;
    }

    public static void main(String[] args) throws Exception {
        TemplateDatabase.getTemplateKeys();
        System.out.println("hasDeployed = " + TemplateDeployer.hasDeployed());
    }
}

