/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.prefs.Locale;
import com.lightcrafts.prefs.PreferencesItem;
import java.awt.event.MouseEvent;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;

class UpdateInteractiveItem
extends PreferencesItem {
    private static final String Package = "/com/lightcrafts/model/ImageEditor";
    private static final String Key = "InteractiveUpdate";
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/model/ImageEditor");
    private static final String FrequentItem = Locale.LOCALE.get("UpdateFrequentLabel");
    private static final String NormalItem = Locale.LOCALE.get("UpdateNormalLabel");
    private static final String InfrequentItem = Locale.LOCALE.get("UpdateInfrequentLabel");
    private static final String DefaultItem = NormalItem;
    private JComboBox combo = new JComboBox();

    UpdateInteractiveItem(JTextArea help) {
        super(help);
        this.combo.addItem(FrequentItem);
        this.combo.addItem(NormalItem);
        this.combo.addItem(InfrequentItem);
        this.combo.setSelectedItem(DefaultItem);
        this.combo.setEditable(false);
        this.addHelpListeners();
    }

    @Override
    public String getLabel() {
        return Locale.LOCALE.get("UpdateInteractiveLabel");
    }

    @Override
    public String getHelp(MouseEvent e) {
        return Locale.LOCALE.get("UpdateInteractiveHelp");
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public JComponent getComponent() {
        Box box = Box.createHorizontalBox();
        box.add(this.combo);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    @Override
    public void commit() {
        String item = (String)this.combo.getSelectedItem();
        int i = UpdateInteractiveItem.itemToInt(item);
        Prefs.putInt(Key, i);
    }

    @Override
    public void restore() {
        int defaultInt = UpdateInteractiveItem.itemToInt(DefaultItem);
        int i = Prefs.getInt(Key, defaultInt);
        String item = UpdateInteractiveItem.intToItem(i);
        this.combo.setSelectedItem(item);
    }

    private static String intToItem(int i) {
        switch (i) {
            case 0: {
                return FrequentItem;
            }
            case 1: {
                return NormalItem;
            }
            case 2: {
                return InfrequentItem;
            }
        }
        assert (false) : "Invalid interactive update option in intToItem()";
        return null;
    }

    private static int itemToInt(String item) {
        if (item.equals(FrequentItem)) {
            return 0;
        }
        if (item.equals(NormalItem)) {
            return 1;
        }
        if (item.equals(InfrequentItem)) {
            return 2;
        }
        assert (false) : "Invalid interactive update option in itemToInt()";
        return -1;
    }
}

