/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.prefs.AppModeItem;
import com.lightcrafts.prefs.AutoSaveItem;
import com.lightcrafts.prefs.BrowserCacheItem;
import com.lightcrafts.prefs.CheckForUpdateItem;
import com.lightcrafts.prefs.ClearPrefsItem;
import com.lightcrafts.prefs.DisplayProfileItem;
import com.lightcrafts.prefs.HeapLimitItem;
import com.lightcrafts.prefs.HelpArea;
import com.lightcrafts.prefs.OtherAppIntegrationItem;
import com.lightcrafts.prefs.PreferencesItem;
import com.lightcrafts.prefs.SaveDirectoryItem;
import com.lightcrafts.prefs.ScratchFileItem;
import com.lightcrafts.prefs.ShowToolTitlesItem;
import com.lightcrafts.prefs.UpdateInteractiveItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PreferencesPanel
extends JPanel {
    private ArrayList<PreferencesItem> items;
    private HelpArea help;

    PreferencesPanel() {
        this.setLayout(new GridBagLayout());
        this.items = new ArrayList();
        this.help = new HelpArea();
        this.addItems();
        this.addFootnote();
    }

    private void addItems() {
        PreferencesPanel.addItem(this, this.items, new HeapLimitItem(this.help));
        PreferencesPanel.addItem(this, this.items, new UpdateInteractiveItem(this.help));
        PreferencesPanel.addItem(this, this.items, new ScratchFileItem(this.help));
        if (Platform.getType() == Platform.Linux) {
            PreferencesPanel.addItem(this, this.items, new DisplayProfileItem(this.help));
        }
        PreferencesPanel.addItem(this, this.items, new BrowserCacheItem(this.help));
        PreferencesPanel.addItem(this, this.items, new CheckForUpdateItem(this.help));
        PreferencesPanel.addItem(this, this.items, new SaveDirectoryItem(this.help));
        PreferencesPanel.addItem(this, this.items, new AutoSaveItem(this.help));
        PreferencesPanel.addItem(this, this.items, new OtherAppIntegrationItem(this.help));
        PreferencesPanel.addItem(this, this.items, new AppModeItem(this.help));
        PreferencesPanel.addItem(this, this.items, new ShowToolTitlesItem(this.help));
        PreferencesPanel.addItem(this, this.items, new ClearPrefsItem(this.help));
    }

    private static void addItem(Container container, Collection<PreferencesItem> items, PreferencesItem item) {
        GridBagConstraints c = new GridBagConstraints();
        String name = item.getLabel();
        JLabel label = new JLabel(name + ":");
        label.setHorizontalAlignment(4);
        JComponent comp = item.getComponent();
        c.gridy = items.size();
        c.ipadx = 2;
        c.ipady = 4;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        c.anchor = 13;
        c.gridx = 0;
        container.add((Component)label, c);
        c.gridx = 1;
        c.anchor = 17;
        container.add((Component)comp, c);
        item.restore();
        items.add(item);
    }

    private void addFootnote() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = this.items.size() + 1;
        c.gridwidth = 2;
        c.fill = 2;
        c.insets = new Insets(4, 5, 0, 5);
        Dimension size = this.help.getPreferredSize();
        size = new Dimension(size.width, 70);
        this.help.setPreferredSize(size);
        this.add((Component)this.help, c);
    }

    void commit() {
        for (PreferencesItem item : this.items) {
            item.commit();
        }
    }
}

