/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.prefs.Locale;
import com.lightcrafts.prefs.PreferencesItem;
import com.lightcrafts.utils.MemoryLimits;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class HeapLimitItem
extends PreferencesItem
implements ChangeListener {
    private static final String Package = "/com/lightcrafts/app";
    private static final String Key = "MaxMemory";
    private static Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/app");
    private JSlider slider;
    private JLabel text;
    private Dimension textSize;
    private Box box;

    HeapLimitItem(JTextArea help) {
        super(help);
        int minimum = MemoryLimits.getMinimum();
        int maximum = MemoryLimits.getMaximum();
        if (maximum > minimum) {
            this.slider = new JSlider(minimum, maximum);
        } else {
            this.slider = new JSlider(0, 1000);
            this.slider.setEnabled(false);
        }
        this.slider.setMajorTickSpacing(maximum / 5);
        this.slider.setMinorTickSpacing(maximum / 20);
        this.slider.setPaintTicks(true);
        this.text = new JLabel();
        this.text.setText(Integer.toString(maximum) + " MB");
        this.text.setHorizontalAlignment(4);
        this.textSize = this.text.getPreferredSize();
        this.slider.setFocusable(false);
        this.slider.addChangeListener(this);
        this.box = Box.createHorizontalBox();
        this.box.add(this.slider);
        this.box.add(Box.createHorizontalStrut(3));
        this.box.add(this.text);
        this.addHelpListeners();
    }

    @Override
    public String getLabel() {
        return Locale.LOCALE.get("HeapLimitItemLabel");
    }

    @Override
    public String getHelp(MouseEvent e) {
        return Locale.LOCALE.get("HeapLimitItemHelp");
    }

    @Override
    public boolean requiresRestart() {
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this.box;
    }

    @Override
    public void commit() {
        if (this.slider.isEnabled()) {
            int value = this.slider.getValue();
            Prefs.putInt(Key, value);
        }
    }

    @Override
    public void restore() {
        if (this.slider.isEnabled()) {
            int defaultValue = MemoryLimits.getDefault();
            int value = Prefs.getInt(Key, defaultValue);
            this.slider.setValue(value);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value = this.slider.getValue();
        String s = Integer.toString(value);
        this.text.setText(s + " MB");
        this.text.setPreferredSize(this.textSize);
    }
}

