/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.platform.AlertDialog;
import com.lightcrafts.platform.FileChooser;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.prefs.PreferencesItem;
import java.awt.color.ICC_Profile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class DisplayProfileItem
extends PreferencesItem
implements ActionListener {
    private static final String Package = "/com/lightcrafts/platform/linux";
    private static final String Key = "DisplayProfile";
    private static Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/platform/linux");
    private JTextField text = new JTextField(20);
    private JButton chooserButton;

    DisplayProfileItem(JTextArea help) {
        super(help);
        this.text.setEditable(false);
        this.chooserButton = new JButton("Choose");
        this.chooserButton.setToolTipText("Pick a new color profile for this display");
        this.chooserButton.addActionListener(this);
        this.addHelpListeners();
    }

    @Override
    public String getLabel() {
        return "Display Color Profile";
    }

    @Override
    public String getHelp(MouseEvent e) {
        return "Set the color profile of your display device.  LightZone must know the correct color profile for your display in order to show colors correctly.  If you do not set this option, LightZone will use an sRGB default profile.";
    }

    @Override
    public boolean requiresRestart() {
        return true;
    }

    @Override
    public JComponent getComponent() {
        Box box = Box.createHorizontalBox();
        box.add(this.text);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.chooserButton);
        return box;
    }

    @Override
    public void commit() {
        String path = this.text.getText();
        Prefs.put(Key, path);
    }

    @Override
    public void restore() {
        String path = Prefs.get(Key, null);
        if (path != null) {
            this.text.setText(path);
            this.text.setEnabled(true);
        } else {
            this.text.setText("(sRGB default)");
            this.text.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        FileChooser chooser = Platform.getPlatform().getFileChooser();
        AlertDialog alert = Platform.getPlatform().getAlertDialog();
        String path = this.text.isEnabled() ? this.text.getText() : System.getProperty("user.home");
        File file = new File(path);
        if ((file = chooser.openFile("Display Color Profile", file, null, null)) != null) {
            if (!file.isFile()) {
                alert.showAlert(null, '\"' + file.getName() + "\" is not a file.", "A color profile is a file, usually ending with \".icc\" or \".icm\".", 1, "OK");
                return;
            }
            try {
                ICC_Profile.getInstance(file.getAbsolutePath());
            }
            catch (IOException e) {
                alert.showAlert(null, '\"' + file.getName() + "\" could not be read.", e.getClass().getName() + ": " + e.getMessage(), 1, "OK");
                return;
            }
            catch (IllegalArgumentException e) {
                alert.showAlert(null, '\"' + file.getName() + "\" is not a valid color profile.", e.getClass().getName() + ": " + e.getMessage(), 1, "OK");
                return;
            }
            path = file.getAbsolutePath();
            this.text.setText(path);
            this.text.setEnabled(true);
            alert.showAlert(null, "Display color profile \"" + file.getName() + "\" accepted.", "You must now restart LightZone for your new display profile to take effect.", 1, "OK");
        }
    }
}

