/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.prefs.ApplicationMode;
import com.lightcrafts.prefs.Locale;
import com.lightcrafts.prefs.PreferencesItem;
import java.awt.event.MouseEvent;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;

class AppModeItem
extends PreferencesItem {
    private static final String Package = "/com/lightcrafts/app";
    private static final String Key = "AppMode";
    private static final String FullValue = "Full";
    private static final String BasicValue = "Basic";
    private static Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/app");
    private JCheckBox checkbox = new JCheckBox();

    AppModeItem(JTextArea help) {
        super(help);
        this.checkbox.setFocusable(false);
        this.addHelpListeners();
        if (!ApplicationMode.canSetBasicMode()) {
            this.checkbox.setEnabled(false);
            this.checkbox.setSelected(true);
        }
    }

    @Override
    public String getLabel() {
        return Locale.LOCALE.get("AppModeItemLabel");
    }

    @Override
    public String getHelp(MouseEvent e) {
        return Locale.LOCALE.get("AppModeItemHelp");
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public JComponent getComponent() {
        return this.checkbox;
    }

    @Override
    public void commit() {
        if (ApplicationMode.canSetBasicMode()) {
            boolean isSelected = this.checkbox.isSelected();
            Prefs.put(Key, isSelected ? BasicValue : FullValue);
        }
    }

    @Override
    public void restore() {
        if (ApplicationMode.canSetBasicMode()) {
            String mode = Prefs.get(Key, FullValue);
            this.checkbox.setSelected(mode.equals(BasicValue));
        }
    }
}

