/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.operator.TransposeDescriptor;
import com.lightcrafts.model.ImageEditor.ImageEditorEngine;
import com.lightcrafts.model.PrintSettings;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.platform.PrinterLayer;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class DefaultPrinterLayer
implements PrinterLayer {
    private PageFormat lastPageFormat;
    private final PrinterJob printJob = PrinterJob.getPrinterJob();
    private Printer printer = null;

    DefaultPrinterLayer() {
        this.lastPageFormat = this.printJob.defaultPage();
    }

    @Override
    public void setPageFormat(PageFormat pageFormat) {
        this.lastPageFormat = this.printJob.validatePage(pageFormat);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public PageFormat getPageFormat() {
        return this.lastPageFormat;
    }

    @Override
    public PageFormat pageDialog(PageFormat pageFormat) {
        this.lastPageFormat = this.printJob.pageDialog(pageFormat);
        return this.lastPageFormat;
    }

    @Override
    public boolean printDialog() {
        return this.printJob.printDialog();
    }

    @Override
    public void setJobName(String name) {
        this.printJob.setJobName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(ImageEditorEngine engine, ProgressThread thread, PageFormat format, PrintSettings settings) throws PrinterException {
        this.printer = new Printer(engine, thread, format, settings, this.printJob);
        try {
            this.printer.doPrint();
        }
        finally {
            this.printer = null;
        }
    }

    @Override
    public void cancelPrint() {
        Printer thePrinter = this.printer;
        if (thePrinter != null) {
            thePrinter.cancelPrint();
        }
    }

    public static PageFormat fixPageFormat(PageFormat format) {
        if (Platform.getType() == Platform.MacOSX) {
            Paper paper = format.getPaper();
            paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
            format.setPaper(paper);
            format = PrinterJob.getPrinterJob().validatePage(format);
        }
        return format;
    }

    private static class Printer
    implements Printable {
        private ImageEditorEngine engine;
        private ProgressThread thread;
        private PageFormat format;
        private PrintSettings settings;
        private PrinterJob printJob;
        private boolean printCancelled = false;
        private boolean fakeLandscape = false;
        private Point2D printOrigin = new Point2D.Double();
        private double PRINTER_RESOLUTION;
        private double printResolution;
        private PlanarImage printImage = null;
        private ProgressIndicator listener = null;
        private boolean firstTime = true;

        Printer(ImageEditorEngine engine, ProgressThread thread, PageFormat format, PrintSettings settings, PrinterJob printJob) {
            this.engine = engine;
            this.thread = thread;
            this.format = format;
            this.settings = settings;
            this.printJob = printJob;
            this.printResolution = this.PRINTER_RESOLUTION = (double)settings.getPixelsPerInch() / 72.0;
        }

        void doPrint() throws PrinterException {
            this.printCancelled = false;
            int orientation = this.format.getOrientation();
            if (orientation != 1 && Platform.getType() == Platform.MacOSX) {
                this.fakeLandscape = true;
            }
            this.createRendering(this.settings, this.thread.getProgressIndicator());
            this.printImage = new Functions.sRGBWrapper((RenderedImage)this.printImage);
            if (!this.printCancelled && !this.thread.isCanceled()) {
                if (this.fakeLandscape) {
                    this.format.setOrientation(1);
                }
                this.printJob.setPrintable(this, this.format);
                this.printJob.print();
                if (this.fakeLandscape) {
                    this.format.setOrientation(orientation);
                    this.fakeLandscape = false;
                }
            }
        }

        void cancelPrint() {
            if (!this.printCancelled) {
                this.printCancelled = true;
                this.printJob.cancel();
            }
        }

        public static PrintResolution effectiveResolution(PrintSettings printSettings, Dimension dimension) {
            double printResolution = (double)printSettings.getPixelsPerInch() / 72.0;
            double printScale = Math.min(printResolution * printSettings.getWidth() / dimension.getWidth(), printResolution * printSettings.getHeight() / dimension.getHeight());
            if (printScale > 1.0) {
                printResolution /= printScale;
                printScale = 1.0;
            }
            return new PrintResolution(printResolution, printScale);
        }

        public void createRendering(PrintSettings printSettings, ProgressIndicator listener) {
            this.listener = listener;
            Dimension dimension = this.engine.getNaturalSize();
            PrintResolution pr = Printer.effectiveResolution(printSettings, dimension);
            this.printResolution = pr.resolution;
            double printX = this.fakeLandscape ? printSettings.getY() : printSettings.getX();
            double printY = this.fakeLandscape ? printSettings.getX() : printSettings.getY();
            this.printOrigin.setLocation(printX, printY);
            System.out.println("print scale: " + pr.scale + ", print resolution: " + 72.0 * this.printResolution + " dpi");
            this.printImage = this.engine.getRendering(new Dimension((int)(pr.scale * (double)dimension.width), (int)(pr.scale * (double)dimension.height)), printSettings.getColorProfile() != null ? printSettings.getColorProfile() : JAIContext.sRGBColorProfile, this.engine.getLCMSIntent(printSettings.getRenderingIntent()), true);
            if (this.printImage instanceof RenderedOp) {
                RenderedOp rop = (RenderedOp)this.printImage;
                rop.setRenderingHint(JAI.KEY_TILE_CACHE, (Object)JAIContext.defaultTileCache);
            }
            if (this.fakeLandscape) {
                ParameterBlock params = new ParameterBlock();
                params.addSource(this.printImage);
                params.add(TransposeDescriptor.ROTATE_90);
                this.printImage = JAI.create((String)"Transpose", (ParameterBlock)params, null);
            }
            if (this.printResolution != this.PRINTER_RESOLUTION) {
                double scale = this.PRINTER_RESOLUTION / this.printResolution;
                System.out.println("Uprezzing by " + scale * 100.0 + '%');
                AffineTransform xform = AffineTransform.getScaleInstance(scale, scale);
                RenderingHints formatHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                Interpolation interp = Interpolation.getInstance((int)3);
                ParameterBlock params = new ParameterBlock();
                params.addSource(this.printImage);
                params.add(xform);
                params.add(interp);
                this.printImage = JAI.create((String)"Affine", (ParameterBlock)params, (RenderingHints)formatHints);
            }
            if (!this.printCancelled) {
                System.out.println("print image bounds: " + this.printImage.getBounds());
            } else {
                System.out.println("cancelled printing");
            }
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
            if (pageIndex > 0) {
                this.listener = null;
                this.printImage.dispose();
                this.printImage = null;
                return 1;
            }
            System.out.println("print image bounds: " + this.printImage.getBounds());
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform at = g2d.getTransform();
            g2d.scale(1.0 / this.PRINTER_RESOLUTION, 1.0 / this.PRINTER_RESOLUTION);
            g2d.translate(this.PRINTER_RESOLUTION * this.printOrigin.getX(), this.PRINTER_RESOLUTION * this.printOrigin.getY());
            g2d.setClip(this.printImage.getBounds());
            System.out.println("printing...");
            if (!this.firstTime) {
                this.listener.setMaximum(this.printImage.getMaxTileX() * this.printImage.getMaxTileY());
            }
            AffineTransform identity = new AffineTransform();
            try {
                if (!this.firstTime) {
                    for (int tileX = 0; !this.printCancelled && tileX < this.printImage.getNumXTiles(); ++tileX) {
                        for (int tileY = 0; !this.printCancelled && tileY < this.printImage.getNumYTiles(); ++tileY) {
                            Raster tile = this.printImage.getTile(tileX, tileY);
                            BufferedImage tileImage = new BufferedImage(this.printImage.getColorModel(), (WritableRaster)tile.createTranslatedChild(0, 0), false, null);
                            g2d.drawRenderedImage(tileImage, AffineTransform.getTranslateInstance(tile.getMinX(), tile.getMinY()));
                            this.listener.incrementBy(1);
                        }
                    }
                } else {
                    g2d.drawRenderedImage((RenderedImage)this.printImage, identity);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.firstTime) {
                this.listener.setIndeterminate(true);
            }
            g2d.setTransform(at);
            System.out.println("...printed!");
            this.firstTime = false;
            return 0;
        }

        private static class PrintResolution {
            final double resolution;
            final double scale;

            PrintResolution(double resolution, double scale) {
                this.resolution = resolution;
                this.scale = scale;
            }
        }
    }
}

