/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.operator.LCMSColorConvertDescriptor;
import com.lightcrafts.jai.opimage.RedMaskBlackener;
import com.lightcrafts.jai.opimage.RedMaskOpImage;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.KernelJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.RedEyeOperation;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.utils.LCMS;
import com.lightcrafts.utils.LCMS_ColorSpace;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;

public class RedEyesOperation
extends BlendedOperation
implements RedEyeOperation {
    private final double step = 0.01;
    static final OperationType type = new OperationTypeImpl("Red Eyes");
    private double tolerance = 1.0;

    public RedEyesOperation(Rendering rendering) {
        super(rendering, type);
        this.addSliderKey("Tolerance");
        DecimalFormat format = new DecimalFormat("0.00");
        this.setSliderConfig("Tolerance", new SliderConfig(0.5, 1.5, this.tolerance, 0.01, false, format));
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public EditorMode getPreferredMode() {
        return EditorMode.REGION;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key != "Tolerance" || this.tolerance == value) {
            return;
        }
        this.tolerance = value;
        super.setSliderValue(key, value);
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new GaussMask(source, this);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    @Override
    public boolean hasFooter() {
        return false;
    }

    private class GaussMask
    extends BlendedOperation.BlendedTransform {
        Operation op;

        GaussMask(PlanarImage source, Operation op) {
            super(source);
            this.op = op;
        }

        @Override
        public PlanarImage setFront() {
            if (RedEyesOperation.this.hasMask()) {
                PlanarImage labImage = Functions.toColorSpace((RenderedImage)this.back, new LCMS_ColorSpace(new LCMS.LABProfile()), LCMSColorConvertDescriptor.RELATIVE_COLORIMETRIC, null);
                RedMaskOpImage redMask = new RedMaskOpImage((RenderedImage)labImage, RedEyesOperation.this.tolerance, null);
                KernelJAI morphKernel = new KernelJAI(3, 3, new float[]{1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f});
                ParameterBlock pb = new ParameterBlock();
                pb.addSource((Object)redMask);
                pb.add(morphKernel);
                redMask = JAI.create((String)"dilate", (ParameterBlock)pb, null);
                KernelJAI blurKernel = Functions.getGaussKernel(4.0f * RedEyesOperation.this.scale);
                pb = new ParameterBlock();
                pb.addSource((Object)redMask);
                pb.add(blurKernel);
                redMask = JAI.create((String)"LCSeparableConvolve", (ParameterBlock)pb, null);
                return new RedMaskBlackener((RenderedImage)this.back, (RenderedImage)((Object)redMask), null);
            }
            return this.back;
        }
    }
}

