/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import Jama.Matrix;
import com.lightcrafts.image.types.AuxiliaryImageInfo;
import com.lightcrafts.image.types.RawImageInfo;
import com.lightcrafts.jai.opimage.HighlightRecoveryOpImage;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.model.ColorDropperOperation;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.ImageEditor.WhiteBalanceV2;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.RawAdjustmentOperation;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import com.lightcrafts.utils.DCRaw;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class RawAdjustmentsOperation
extends BlendedOperation
implements ColorDropperOperation,
RawAdjustmentOperation {
    private static final String SOURCE = "Temperature";
    private static final String TINT = "Tint";
    private static final String EXPOSURE = "Exposure";
    private static final String COLOR_NOISE = "Color_Noise";
    private final float originalTemperature;
    private final float daylightTemperature;
    private float temperature = 5000.0f;
    private float tint = 0.0f;
    private float exposure = 0.0f;
    private float color_noise = 4.0f;
    private Point2D p = null;
    private boolean autoWB = false;
    private float[][] cameraRGBWB;
    private float[][] cameraRGBCA;
    private float[] daylightMultipliers;
    private float[] preMul;
    private float[] cameraMultipliers;
    private static final ColorScience.CAMethod caMethod = ColorScience.CAMethod.Mixed;
    static final OperationType type = new OperationTypeImpl("RAW Adjustments");
    static final Matrix RGBtoZYX = new Matrix(ColorScience.RGBtoZYX()).transpose();
    static final Matrix XYZtoRGB = RGBtoZYX.inverse();

    private float mixer(float t) {
        double p = (t - this.originalTemperature) / 2000.0f;
        return p > -1.0 && p < 1.0 ? (float)(Math.cos(Math.PI * p) + 1.0) / 2.0f : 0.0f;
    }

    private float[][] cameraRGB(float t) {
        if (this.cameraRGBWB == null) {
            return this.cameraRGBCA;
        }
        float[][] matrix = new float[3][3];
        float m = this.mixer(t);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                matrix[i][j] = this.cameraRGBCA[i][j] * (1.0f - m) + this.cameraRGBWB[i][j] * m;
            }
        }
        return matrix;
    }

    public RawAdjustmentsOperation(Rendering rendering) {
        super(rendering, type);
        this.colorInputOnly = true;
        AuxiliaryImageInfo auxInfo = rendering.getEngine().getAuxInfo();
        if (auxInfo instanceof RawImageInfo) {
            DCRaw dcRaw = ((RawImageInfo)auxInfo).getDCRaw();
            this.daylightMultipliers = dcRaw.getDaylightMultipliers();
            this.preMul = (float[])this.daylightMultipliers.clone();
            this.cameraMultipliers = dcRaw.getCameraMultipliers();
            if (this.daylightMultipliers[0] != 0.0f) {
                this.daylightTemperature = RawAdjustmentsOperation.neutralTemperature(this.daylightMultipliers, 5000.0f);
                System.out.println("daylightMultipliers: " + this.daylightMultipliers[0] + ", " + this.daylightMultipliers[1] + ", " + this.daylightMultipliers[2]);
                System.out.println("Daylight Temperature : " + this.daylightTemperature);
            } else {
                this.daylightTemperature = 5000.0f;
            }
            if (this.cameraMultipliers[0] != 0.0f) {
                this.originalTemperature = this.temperature = RawAdjustmentsOperation.neutralTemperature(this.cameraMultipliers, 5000.0f);
                System.out.println("cameraMultipliers: " + this.cameraMultipliers[0] + ", " + this.cameraMultipliers[1] + ", " + this.cameraMultipliers[2]);
                System.out.println("Camera Temperature: " + this.originalTemperature);
            } else {
                this.originalTemperature = this.temperature = this.daylightTemperature;
            }
            double dmax = Math.max(this.daylightMultipliers[0], Math.max(this.daylightMultipliers[1], this.daylightMultipliers[2]));
            int c = 0;
            while (c < 3) {
                int n = c++;
                this.daylightMultipliers[n] = (float)((double)this.daylightMultipliers[n] / dmax);
            }
            if (this.cameraMultipliers[0] > 0.0f) {
                float[] wb = new float[]{this.cameraMultipliers[0] / (this.cameraMultipliers[1] * this.daylightMultipliers[0]), this.cameraMultipliers[1] / (this.cameraMultipliers[1] * this.daylightMultipliers[1]), this.cameraMultipliers[2] / (this.cameraMultipliers[1] * this.daylightMultipliers[2])};
                System.out.println("Scaling with: " + wb[0] + ", " + wb[1] + ", " + wb[2]);
                System.out.println("Correlated Temperature: " + RawAdjustmentsOperation.neutralTemperature(wb, 5000.0f));
                this.cameraRGBWB = dcRaw.getCameraRGB();
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        float[] fArray = this.cameraRGBWB[j];
                        int n = i;
                        fArray[n] = fArray[n] * wb[i];
                    }
                }
                Matrix B = new Matrix(ColorScience.chromaticAdaptation(this.daylightTemperature, this.originalTemperature, caMethod));
                Matrix combo = XYZtoRGB.times(B.times(RGBtoZYX));
                this.cameraRGBWB = combo.inverse().times(new Matrix(this.cameraRGBWB)).getArrayFloat();
            }
            this.cameraRGBCA = dcRaw.getCameraRGB();
            dcRaw.getDaylightMultipliers();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    float[] fArray = this.cameraRGBCA[j];
                    int n = i;
                    fArray[n] = (float)((double)fArray[n] * dmax);
                }
            }
        } else {
            this.originalTemperature = 5000.0f;
            this.daylightTemperature = 5000.0f;
        }
        this.addSliderKey(EXPOSURE);
        this.addSliderKey(COLOR_NOISE);
        this.addSliderKey(SOURCE);
        this.addSliderKey(TINT);
        DecimalFormat format = new DecimalFormat("0.00");
        this.setSliderConfig(EXPOSURE, new SliderConfig(-4.0, 4.0, this.exposure, 0.01, false, format));
        this.setSliderConfig(SOURCE, new SliderConfig(1000.0, 40000.0, this.temperature, 10.0, true, new DecimalFormat("0")));
        this.setSliderConfig(TINT, new SliderConfig(-20.0, 20.0, this.tint, 0.1, false, new DecimalFormat("0.0")));
        this.setSliderConfig(COLOR_NOISE, new SliderConfig(0.0, 20.0, this.color_noise, 0.01, false, format));
    }

    static float neutralTemperature(float[] rgb, float refT) {
        float sat = Float.MAX_VALUE;
        float minT = 0.0f;
        int t = 1000;
        while (t < 40000) {
            double b;
            double g;
            Matrix B = new Matrix(ColorScience.chromaticAdaptation(t, refT, caMethod));
            Matrix combo = XYZtoRGB.times(B.times(RGBtoZYX));
            Matrix color = new Matrix(new double[][]{{rgb[0]}, {rgb[1]}, {rgb[2]}});
            double r = (color = combo.times(color)).get(0, 0);
            float tSat = (float)ColorScience.saturation(r, g = color.get(1, 0), b = color.get(2, 0));
            if (tSat < sat) {
                sat = tSat;
                minT = t;
            }
            t = (int)((double)t + 0.01 * (double)t);
        }
        return minT;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key == SOURCE && (double)this.temperature != value) {
            this.temperature = (float)value;
        } else if (key == TINT && (double)this.tint != value) {
            this.tint = (float)value;
        } else if (key == EXPOSURE && (double)this.exposure != value) {
            this.exposure = (float)value;
        } else if (key == COLOR_NOISE && (double)this.color_noise != value) {
            this.color_noise = (float)value;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    @Override
    public Map<String, Float> setColor(Point2D p) {
        this.p = p;
        this.settingsChanged();
        this.p = null;
        TreeMap<String, Float> result = new TreeMap<String, Float>();
        result.put(SOURCE, Float.valueOf(this.temperature));
        result.put(TINT, Float.valueOf(this.tint));
        return result;
    }

    @Override
    public Map<String, Double> getAuto() {
        this.autoWB = true;
        this.settingsChanged();
        this.autoWB = false;
        TreeMap<String, Double> result = new TreeMap<String, Double>();
        result.put(SOURCE, Double.valueOf(this.temperature));
        result.put(TINT, Double.valueOf(this.tint));
        return result;
    }

    @Override
    public Map<String, Double> getAsShot() {
        TreeMap<String, Double> result = new TreeMap<String, Double>();
        result.put(SOURCE, Double.valueOf(this.originalTemperature));
        result.put(TINT, 0.0);
        return result;
    }

    int[] getPixel(PlanarImage image, int x, int y, int[] pixel) {
        Raster tile = image.getTile(image.XToTileX(x), image.YToTileY(y));
        return tile != null ? tile.getPixel(x, y, pixel) : null;
    }

    private float[] autoWhiteBalance(PlanarImage image) {
        int iheight = image.getHeight();
        int iwidth = image.getWidth();
        double[] dsum = new double[6];
        int[] sum = new int[6];
        int maximum = 65535;
        int black = 0;
        int[] pixel = new int[3];
        int[] caPixel = new int[3];
        for (int row = 0; row < iheight - 7; row += 8) {
            block1: for (int col = 0; col < iwidth - 7; col += 8) {
                Arrays.fill(sum, 0);
                for (int y = row; y < row + 8; ++y) {
                    for (int x = col; x < col + 8; ++x) {
                        pixel = this.getPixel(image, x, y, pixel);
                        Arrays.fill(caPixel, 0);
                        for (int i = 0; i < 3; ++i) {
                            for (int j = 0; j < 3; ++j) {
                                int n = j;
                                caPixel[n] = caPixel[n] + (int)((float)pixel[i] * this.cameraRGBCA[j][i]);
                            }
                        }
                        for (int c = 0; c < 3; ++c) {
                            int val = caPixel[c];
                            if (val == 0) continue;
                            if (val > maximum - 25) continue block1;
                            if ((val -= black) < 0) {
                                val = 0;
                            }
                            int n = c;
                            sum[n] = sum[n] + val;
                            int n2 = c + 3;
                            sum[n2] = sum[n2] + 1;
                        }
                    }
                }
                for (int c = 0; c < 6; ++c) {
                    int n = c;
                    dsum[n] = dsum[n] + (double)sum[c];
                }
            }
        }
        float[] pre_mul = new float[3];
        for (int c = 0; c < 3; ++c) {
            if (dsum[c] == 0.0) continue;
            pre_mul[c] = (float)(dsum[c + 3] / dsum[c]);
        }
        double dmax = Math.max(pre_mul[0], Math.max(pre_mul[1], pre_mul[2]));
        int c = 0;
        while (c < 3) {
            int n = c++;
            pre_mul[n] = (float)((double)pre_mul[n] / dmax);
        }
        return pre_mul;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new RawAdjustments(source);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    private class RawAdjustments
    extends BlendedOperation.BlendedTransform {
        RawAdjustments(PlanarImage source) {
            super(source);
        }

        @Override
        public PlanarImage setFront() {
            int[] pixel;
            Object front = this.back;
            float lightness = 0.18f;
            if (RawAdjustmentsOperation.this.autoWB) {
                float[] wb = RawAdjustmentsOperation.this.autoWhiteBalance(this.back);
                System.out.println("Auto WB: " + wb[0] + ", " + wb[1] + ", " + wb[2]);
                RawAdjustmentsOperation.this.temperature = RawAdjustmentsOperation.neutralTemperature(wb, RawAdjustmentsOperation.this.daylightTemperature);
                RawAdjustmentsOperation.this.tint = 0.0f;
                System.out.println("Correlated Temperature: " + RawAdjustmentsOperation.this.temperature);
            } else if (RawAdjustmentsOperation.this.p != null && (pixel = this.pointToPixel(RawAdjustmentsOperation.this.p)) != null) {
                float oldTemperature = 0.0f;
                for (int k = 0; k < 10 && (double)Math.abs(oldTemperature - RawAdjustmentsOperation.this.temperature) > 0.01 * (double)RawAdjustmentsOperation.this.temperature; ++k) {
                    oldTemperature = RawAdjustmentsOperation.this.temperature;
                    int[] newPixel = new int[3];
                    for (int i = 0; i < 3; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            int n = j;
                            newPixel[n] = newPixel[n] + (int)((float)pixel[i] * RawAdjustmentsOperation.this.cameraRGB(RawAdjustmentsOperation.this.temperature)[j][i]);
                        }
                    }
                    float[] n = WhiteBalanceV2.neutralize(newPixel, caMethod, RawAdjustmentsOperation.this.temperature, RawAdjustmentsOperation.this.daylightTemperature);
                    lightness = (float)newPixel[1] / 255.0f;
                    RawAdjustmentsOperation.this.temperature = n[0];
                    RawAdjustmentsOperation.this.tint = Math.min(Math.max(n[1], -20.0f), 20.0f);
                }
            }
            Matrix B = new Matrix(ColorScience.chromaticAdaptation(RawAdjustmentsOperation.this.daylightTemperature, RawAdjustmentsOperation.this.temperature, caMethod));
            Matrix CA = XYZtoRGB.times(B.times(RGBtoZYX));
            Matrix m = CA.times(new Matrix(new double[][]{{1.0}, {1.0}, {1.0}}));
            double max = m.get(1, 0);
            if (max != 1.0) {
                CA = CA.times(new Matrix(new double[][]{{1.0 / max, 0.0, 0.0}, {0.0, 1.0 / max, 0.0}, {0.0, 0.0, 1.0 / max}}));
            }
            float[][] camMatrix = new Matrix(RawAdjustmentsOperation.this.cameraRGB(RawAdjustmentsOperation.this.temperature)).times(Math.pow(2.0, RawAdjustmentsOperation.this.exposure)).getArrayFloat();
            front = new HighlightRecoveryOpImage((RenderedImage)front, RawAdjustmentsOperation.this.preMul, camMatrix, CA.getArrayFloat(), null);
            if (RawAdjustmentsOperation.this.tint != 0.0f) {
                front = WhiteBalanceV2.tintCast(front, RawAdjustmentsOperation.this.tint, lightness);
            }
            front.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
            RenderingHints mfHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            if (RawAdjustmentsOperation.this.color_noise != 0.0f) {
                ColorScience.YST transform = new ColorScience.YST();
                double[][] rgb2llab = transform.fromRGB(this.back.getSampleModel().getDataType());
                double[][] llab2rgb = transform.toRGB(this.back.getSampleModel().getDataType());
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(front);
                pb.add(rgb2llab);
                RenderedOp ystImage = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
                pb = new ParameterBlock();
                pb.addSource(ystImage);
                pb.add(RawAdjustmentsOperation.this.color_noise * RawAdjustmentsOperation.this.scale);
                pb.add(0.02f + 0.001f * RawAdjustmentsOperation.this.color_noise);
                ystImage = JAI.create((String)"BilateralFilter", (ParameterBlock)pb, (RenderingHints)mfHints);
                pb = new ParameterBlock();
                pb.addSource(ystImage);
                pb.add(llab2rgb);
                front = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
                front.setProperty("LCPersistentCache", (Object)Boolean.TRUE);
            }
            return front;
        }
    }
}

