/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.TileRequest;
import com.lightcrafts.model.ImageEditor.PaintContext;
import com.lightcrafts.model.ImageEditor.TileHandler;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;

class PaintRequest
implements PaintContext {
    final PlanarImage image;
    final int epoch;
    private final boolean synchronous;
    private final boolean prefetch;
    private final TileHandler tileHandler;
    private TileRequest tileRequest = null;
    private int pendingTiles;
    private Set tiles = new HashSet();
    private Set handledTiles = new HashSet();
    private boolean cancelled = false;

    PaintRequest(PlanarImage image, int epoch, Point[] tileIndices, boolean syncronous, boolean prefetch, TileHandler handler) {
        this.image = image;
        this.epoch = epoch;
        this.synchronous = syncronous;
        this.prefetch = prefetch;
        this.tileHandler = handler;
        this.pendingTiles = tileIndices.length;
        this.tileRequest = image.queueTiles(tileIndices);
        for (int i = 0; i < tileIndices.length; ++i) {
            this.tiles.add(new Point(tileIndices[i].x, tileIndices[i].y));
        }
    }

    @Override
    public boolean isPrefetch() {
        return this.prefetch;
    }

    @Override
    public boolean isSynchronous() {
        return this.synchronous;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public PlanarImage getImage() {
        return this.image;
    }

    void cancel() {
        assert (!this.cancelled);
        this.cancelled = true;
        this.image.cancelTiles(this.tileRequest, null);
    }

    TileRequest getTileRequest() {
        assert (this.tileRequest != null);
        return this.tileRequest;
    }

    int getPendingTiles() {
        return this.pendingTiles;
    }

    boolean hasTile(Point tile) {
        return this.tiles.contains(tile);
    }

    boolean handleTile(int tileX, int tileY) {
        Point thisTile = new Point(tileX, tileY);
        if (!this.cancelled && this.tiles.contains(thisTile) && !this.handledTiles.contains(thisTile)) {
            this.tileHandler.handle(tileX, tileY, this);
            this.handledTiles.add(thisTile);
            --this.pendingTiles;
            return true;
        }
        return false;
    }
}

