/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.OpImage;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.TileCache;
import com.lightcrafts.mediax.jai.TileComputationListener;
import com.lightcrafts.model.Engine;
import com.lightcrafts.model.EngineListener;
import com.lightcrafts.model.ImageEditor.PaintContext;
import com.lightcrafts.model.ImageEditor.PaintListener;
import com.lightcrafts.model.ImageEditor.TileHandler;
import com.lightcrafts.model.ImageEditor.TileManager;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.utils.SoftValueHashMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ImageEditorDisplay
extends JPanel {
    private static final boolean ADVANCED_REPAINT = true;
    private static final boolean ASYNCH_REPAINT = true;
    private PlanarImage source = null;
    private int epoch = 0;
    private static TileManager tileManager = new TileManager();
    private LinkedList<EngineListener> engineListeners = null;
    private PaintListener paintListener = null;
    private boolean synchronizedImage = false;
    private LCTileHandler tileHandler = new LCTileHandler();
    private ProgressNotifyer progressNotifyer = new ProgressNotifyer();
    private RenderedImage backgroundImage;
    SoftValueHashMap backgroundCache = null;
    LinkedList<ComponentListener> compListeners = new LinkedList();
    private boolean[][] validImageBackground = null;
    Engine engine = null;
    RenderedImage lastPreview = null;
    private static final Color backgroundColor = LightZoneSkin.Colors.EditorBackground;
    private static final AffineTransform identityTransform = new AffineTransform();
    private long startGetTiles;
    private boolean computingTiles = false;
    private static final ColorModel sRGBColorModel = new ComponentColorModel(JAIContext.sRGBColorSpace, false, false, 1, 0);
    private boolean firstTime;
    final Timer paintTimer = new Timer(300, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageEditorDisplay.this.firstTime = false;
            ImageEditorDisplay.this.paintTimer.stop();
            ImageEditorDisplay.this.repaint();
        }
    });

    @Override
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        ComponentEvent event = new ComponentEvent(this, 101);
        for (ComponentListener listener : this.compListeners) {
            listener.componentResized(event);
        }
    }

    @Override
    public void addComponentListener(ComponentListener listener) {
        this.compListeners.add(listener);
        super.addComponentListener(listener);
    }

    @Override
    public void removeComponentListener(ComponentListener listener) {
        this.compListeners.remove(listener);
        super.removeComponentListener(listener);
    }

    public ImageEditorDisplay(Engine engine, PlanarImage image) {
        super(null);
        this.engine = engine;
        this.source = image;
        if (this.source != null) {
            this.backgroundCache = new SoftValueHashMap();
            this.source.addTileComputationListener((TileComputationListener)tileManager);
            this.setPreferredSize(new Dimension(this.source.getWidth(), this.source.getHeight()));
        }
        this.setOpaque(true);
        this.synchronizedImage = false;
    }

    public void dispose() {
        if (this.source != null) {
            this.source.removeTileComputationListener((TileComputationListener)tileManager);
            tileManager.cancelTiles(this.source, this.epoch);
            this.source.dispose();
            this.source = null;
        }
        if (this.backgroundCache != null) {
            this.backgroundCache = null;
        }
        this.engineListeners = null;
        this.paintListener = null;
        this.tileHandler = null;
        this.progressNotifyer = null;
    }

    public synchronized void set(PlanarImage image, boolean synchronous) {
        if (image == null) {
            throw new IllegalArgumentException("cannot set a null image!");
        }
        if (this.source != null) {
            this.source.removeTileComputationListener((TileComputationListener)tileManager);
            tileManager.cancelTiles(this.source, this.epoch);
            this.source.dispose();
        }
        PlanarImage oldImage = this.source;
        this.source = image;
        ++this.epoch;
        this.source.addTileComputationListener((TileComputationListener)tileManager);
        int maxTileX = this.source.getMaxTileX();
        int maxTileY = this.source.getMaxTileY();
        this.validImageBackground = new boolean[maxTileX + 1][maxTileY + 1];
        this.synchronizedImage = synchronous;
        if (oldImage == null || !oldImage.getBounds().equals(image.getBounds())) {
            this.backgroundCache = new SoftValueHashMap();
            Dimension dim = new Dimension(this.source.getWidth(), this.source.getHeight());
            this.setPreferredSize(dim);
        }
        this.repaint();
    }

    public void setEngineListeners(LinkedList<EngineListener> engineListeners) {
        this.engineListeners = engineListeners;
    }

    public void setPaintListener(PaintListener listener) {
        this.paintListener = listener;
    }

    public RenderedImage getSource() {
        return this.source;
    }

    synchronized void repaintTile(PaintContext ctx, int tileX, int tileY) {
        if (!ctx.isCancelled() && ctx.getImage() == this.source) {
            if (!ctx.isPrefetch()) {
                PlanarImage currentSource = this.source;
                boolean currentSynchronized = this.synchronizedImage;
                this.source = ctx.getImage();
                this.synchronizedImage = ctx.isSynchronous();
                this.paintImmediately(tileX * this.source.getTileWidth(), tileY * this.source.getTileHeight(), this.source.getTileWidth(), this.source.getTileHeight());
                this.synchronizedImage = currentSynchronized;
                this.source = currentSource;
            } else {
                this.progressNotifyer.setTiles(tileManager.pendingTiles(this.source, this.epoch));
            }
        }
    }

    private Raster[] availableTiles(Point[] tileIndices) {
        OpImage ro;
        if (this.source instanceof OpImage) {
            ro = (OpImage)this.source;
        } else {
            PlanarImage rendering = ((RenderedOp)this.source).getCurrentRendering();
            ro = (OpImage)rendering;
        }
        TileCache cache = ro.getTileCache();
        return cache.getTiles((RenderedImage)ro, tileIndices);
    }

    BufferedImage getBackgroundTile(WritableRaster tile, int x, int y) {
        CacheKey key = new CacheKey(x, y);
        BufferedImage image = (BufferedImage)this.backgroundCache.get(key);
        BufferedImage tileImage = new BufferedImage(sRGBColorModel, (WritableRaster)tile.createTranslatedChild(0, 0), false, null);
        if (image != null && image.getWidth() == tile.getWidth() && image.getHeight() == tile.getHeight()) {
            Graphics2D big = (Graphics2D)image.getGraphics();
            big.drawRenderedImage(tileImage, new AffineTransform());
            big.dispose();
        } else {
            image = Functions.toFastBufferedImage(tileImage);
            this.backgroundCache.put(key, image);
        }
        return image;
    }

    void setFirstTime() {
        this.firstTime = true;
    }

    void setBackgroundImage(RenderedImage image) {
        this.backgroundImage = image;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        if (this.firstTime) {
            if (!this.paintTimer.isRunning()) {
                this.paintTimer.start();
            }
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.source == null) {
            g2d.setColor(backgroundColor);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        g2d.setColor(Color.blue);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        Rectangle clipBounds = g2d.getClipBounds();
        Point[] tileIndices = this.source.getTileIndices(clipBounds);
        if (tileIndices == null) {
            return;
        }
        LinkedList<Point> dirtyTiles = new LinkedList<Point>();
        Raster[] tiles = this.availableTiles(tileIndices);
        for (int i = 0; i < tileIndices.length; ++i) {
            Rectangle tileClipRect = new Rectangle(tileIndices[i].x * 256, tileIndices[i].y * 256, 256, 256);
            g2d.setClip(tileClipRect.intersection(clipBounds));
            if (this.validImageBackground[tileIndices[i].x][tileIndices[i].y] || tiles == null || tiles[i] == null) {
                BufferedImage backgroundTile;
                if (!this.validImageBackground[tileIndices[i].x][tileIndices[i].y]) {
                    dirtyTiles.add(tileIndices[i]);
                }
                if ((backgroundTile = (BufferedImage)this.backgroundCache.get(new CacheKey(tileIndices[i].x, tileIndices[i].y))) != null) {
                    int xOffset = this.source.tileXToX(tileIndices[i].x);
                    int yOffset = this.source.tileYToY(tileIndices[i].y);
                    try {
                        g2d.drawImage(backgroundTile, null, xOffset, yOffset);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                Raster[] cachedTiles = this.availableTiles(new Point[]{new Point(tileIndices[i].x, tileIndices[i].y)});
                if (cachedTiles.length == 1 && cachedTiles[0] != null) {
                    WritableRaster tile = (WritableRaster)cachedTiles[0];
                    BufferedImage image = this.getBackgroundTile(tile, tileIndices[i].x, tileIndices[i].y);
                    g2d.drawImage(image, null, tile.getMinX(), tile.getMinY());
                    continue;
                }
                if (this.backgroundImage != null) {
                    g2d.drawRenderedImage(this.backgroundImage, new AffineTransform());
                    continue;
                }
                g2d.setColor(backgroundColor);
                g2d.fillRect(tileClipRect.x, tileClipRect.y, tileClipRect.width, tileClipRect.height);
                continue;
            }
            try {
                WritableRaster tile = (WritableRaster)tiles[i];
                BufferedImage image = this.getBackgroundTile(tile, tileIndices[i].x, tileIndices[i].y);
                g2d.drawImage(image, null, tile.getMinX(), tile.getMinY());
                this.validImageBackground[tileIndices[i].x][tileIndices[i].y] = true;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        g2d.setClip(clipBounds);
        if (!dirtyTiles.isEmpty()) {
            this.startGetTiles = System.currentTimeMillis();
            Collections.sort(dirtyTiles, new TileComparator((clipBounds.x + clipBounds.width / 2) / this.source.getTileWidth(), (clipBounds.y + clipBounds.height / 2) / this.source.getTileHeight()));
            this.computingTiles = true;
            tileManager.queueTiles(this.source, this.epoch, dirtyTiles, this.synchronizedImage, false, this.tileHandler);
        } else if (tileManager.pendingTiles(this.source, this.epoch) == 0) {
            long endGetTiles = System.currentTimeMillis();
            if (this.paintListener != null) {
                if (this.computingTiles) {
                    if (this.synchronizedImage) {
                        if (this.startGetTiles > 0L) {
                            this.paintListener.paintDone(this.source, this.getVisibleRect(), this.synchronizedImage, endGetTiles - this.startGetTiles);
                        }
                    } else {
                        this.paintListener.paintDone(this.source, this.getVisibleRect(), this.synchronizedImage, 0L);
                    }
                } else {
                    this.paintListener.paintDone(this.source, this.getVisibleRect(), this.synchronizedImage, 0L);
                }
            }
            this.startGetTiles = -1L;
            this.computingTiles = false;
        }
        this.progressNotifyer.setTiles(tileManager.pendingTiles(this.source, this.epoch));
    }

    static class TileComparator
    implements Comparator<Point> {
        int x;
        int y;

        TileComparator(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public int compare(Point t1, Point t2) {
            int dx1 = t1.x - this.x;
            int dy1 = t1.y - this.y;
            int dx2 = t2.x - this.x;
            int dy2 = t2.y - this.y;
            if (dx1 * dx1 + dy1 * dy1 > dx2 * dx2 + dy2 * dy2) {
                return 1;
            }
            if (dx1 * dx1 + dy1 * dy1 < dx2 * dx2 + dy2 * dy2) {
                return -1;
            }
            return 0;
        }
    }

    class ProgressNotifyer {
        private int queuedTiles = 0;

        ProgressNotifyer() {
        }

        private void notifyListeners() {
            if (ImageEditorDisplay.this.engineListeners != null) {
                for (EngineListener listener : ImageEditorDisplay.this.engineListeners) {
                    listener.engineActive(this.queuedTiles);
                }
            }
        }

        public synchronized void setTiles(int numTiles) {
            this.queuedTiles = numTiles;
            this.notifyListeners();
        }
    }

    class AsynchronousRepainter
    implements Runnable {
        private int tileX;
        private int tileY;
        private PaintContext ctx;

        AsynchronousRepainter(int tileX, int tileY, PaintContext ctx) {
            this.tileX = tileX;
            this.tileY = tileY;
            this.ctx = ctx;
        }

        @Override
        public void run() {
            ImageEditorDisplay.this.repaintTile(this.ctx, this.tileX, this.tileY);
        }
    }

    class LCTileHandler
    implements TileHandler {
        LCTileHandler() {
        }

        @Override
        public void handle(int tileX, int tileY, PaintContext ctx) {
            EventQueue.invokeLater(new AsynchronousRepainter(tileX, tileY, ctx));
        }
    }

    static class CacheKey {
        final int tileX;
        final int tileY;

        CacheKey(int _tileX, int _tileY) {
            this.tileX = _tileX;
            this.tileY = _tileY;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.tileX == cacheKey.tileX && this.tileY == cacheKey.tileY;
        }

        public int hashCode() {
            int result = this.tileX;
            result = 29 * result + this.tileY;
            return result;
        }
    }
}

