/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.opimage.HueRotateOpImage;
import com.lightcrafts.jai.opimage.IntVibranceOpImage;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorMatrix2;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;

public class HueSaturationOperation
extends BlendedOperation {
    static final String HUE = "Hue";
    static final String SATURATION = "Saturation";
    static final String VIBRANCE = "Vibrance";
    static final String LUMINOSITY = "Luminosity";
    static final OperationType typeV1 = new OperationTypeImpl("Hue/Saturation");
    static final OperationType typeV2 = new OperationTypeImpl("Hue/Saturation V2");
    static final OperationType typeV3 = new OperationTypeImpl("Hue/Saturation V3");
    private float hue = 0.0f;
    private float saturation = 0.0f;
    private float vibrance = 0.0f;
    private float intensity = 0.0f;

    public HueSaturationOperation(Rendering rendering, OperationType type) {
        super(rendering, type);
        this.colorInputOnly = true;
        if (type != typeV2) {
            this.addSliderKey(HUE);
        }
        this.addSliderKey(SATURATION);
        if (type != typeV1) {
            this.addSliderKey(VIBRANCE);
        }
        if (type != typeV2) {
            this.addSliderKey(LUMINOSITY);
        }
        if (type == typeV2) {
            this.addSliderKey(HUE);
        }
        DecimalFormat format = new DecimalFormat("0");
        this.setSliderConfig(HUE, new SliderConfig(-180.0, 180.0, this.hue, 1.0, false, format));
        this.setSliderConfig(SATURATION, new SliderConfig(-100.0, 100.0, this.saturation, 1.0, false, format));
        if (type != typeV1) {
            this.setSliderConfig(VIBRANCE, new SliderConfig(-100.0, 100.0, this.vibrance, 1.0, false, format));
        }
        if (type != typeV2) {
            this.setSliderConfig(LUMINOSITY, new SliderConfig(-100.0, 100.0, this.intensity, 1.0, false, format));
        }
    }

    @Override
    public boolean neutralDefault() {
        return true;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key == HUE && (double)this.hue != value) {
            this.hue = (float)value;
        } else if (key == SATURATION && (double)this.saturation != value) {
            this.saturation = (float)value;
        } else if (key == VIBRANCE && (double)this.vibrance != value) {
            this.vibrance = (float)value;
        } else if (key == LUMINOSITY && (double)this.intensity != value) {
            this.intensity = (float)value;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    private double[][] computeTransform() {
        float[][] matrix = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
        if ((double)this.saturation != 0.0) {
            ColorMatrix2.saturatemat(matrix, this.saturation / 100.0f + 1.0f);
        }
        if ((double)this.intensity != 0.0) {
            float lit = this.intensity / 100.0f + 1.0f;
            ColorMatrix2.cscalemat(matrix, lit, lit, lit);
        }
        double[][] transform = new double[3][4];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                transform[i][j] = matrix[j][i];
            }
        }
        return transform;
    }

    private float[][] computeVibranceTransform() {
        float[][] matrix = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
        if ((double)this.vibrance != 0.0) {
            ColorMatrix2.saturatemat(matrix, this.vibrance / 100.0f + 1.0f);
        }
        float[][] transform = new float[3][4];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                transform[i][j] = matrix[j][i];
            }
        }
        return transform;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new HueSaturation(source);
    }

    @Override
    public OperationType getType() {
        return this.type;
    }

    private class HueSaturation
    extends BlendedOperation.BlendedTransform {
        HueSaturation(PlanarImage source) {
            super(source);
        }

        @Override
        public PlanarImage setFront() {
            double[][] hslTransform = HueSaturationOperation.this.computeTransform();
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            pb.add(hslTransform);
            Object image = JAI.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
            if ((double)HueSaturationOperation.this.vibrance != 0.0) {
                image = new IntVibranceOpImage((RenderedImage)image, HueSaturationOperation.this.computeVibranceTransform(), null);
            }
            if ((double)HueSaturationOperation.this.hue != 0.0) {
                image = new HueRotateOpImage((RenderedImage)image, HueSaturationOperation.this.hue / 360.0f, null);
            }
            return image;
        }
    }
}

