/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.Histogram;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.ImageEditorEngine;
import com.lightcrafts.model.ImageEditor.PaintListener;
import com.lightcrafts.model.Preview;
import com.lightcrafts.model.Region;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;

public class HistogramPreview
extends Preview
implements PaintListener {
    private int[][] bins = null;
    private double[][] controlPoints = null;
    private int currentFocusZone = -1;
    final ImageEditorEngine engine;
    static float[] logTable = new float[65536];
    private Histogrammer histogrammer = null;

    HistogramPreview(ImageEditorEngine engine) {
        this.engine = engine;
    }

    @Override
    public String getName() {
        return "Histogram";
    }

    @Override
    public void setDropper(Point p) {
    }

    @Override
    public void setRegion(Region region) {
    }

    @Override
    public void addNotify() {
        this.engine.update(null, false);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    public void setFocusedZone(int index, double[][] controlPoints) {
        if (this.currentFocusZone != index || this.controlPoints != controlPoints) {
            this.currentFocusZone = index;
            this.controlPoints = controlPoints;
            this.repaint();
        }
    }

    private int binmax() {
        int max = 0;
        for (int c = 0; c < this.bins.length; ++c) {
            int numBins = this.bins[c].length;
            for (int i = 5; i < numBins - 5; ++i) {
                if (this.bins[c][i] <= max) continue;
                max = this.bins[c][i];
            }
        }
        return (int)(1.1 * (double)max);
    }

    @Override
    public void setSelected(Boolean selected) {
        if (!selected.booleanValue()) {
            this.bins = null;
        }
    }

    @Override
    protected synchronized void paintComponent(Graphics gr) {
        Graphics2D g2d = (Graphics2D)gr;
        if (this.bins == null) {
            this.engine.update(null, false);
        }
        Dimension bounds = this.getSize();
        float minx = 0.0f;
        float miny = 0.0f;
        float width = bounds.width;
        final float height = bounds.height - 18;
        g2d.setColor(Color.lightGray);
        g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, width, height + 18.0f));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.bins != null) {
            final int max = this.binmax();
            class Scaler {
                Scaler() {
                }

                int yscale(double y) {
                    return (int)((double)height - (double)(height - 4.0f) * (y / (double)max) + 0.5 + 0.0);
                }
            }
            Scaler s = new Scaler();
            for (int c = 0; c < this.bins.length; ++c) {
                Color color = Color.BLACK;
                if (this.bins.length > 1) {
                    switch (c) {
                        case 0: {
                            color = Color.RED;
                            break;
                        }
                        case 1: {
                            color = Color.GREEN;
                            break;
                        }
                        case 2: {
                            color = Color.BLUE;
                        }
                    }
                }
                g2d.setColor(color);
                int numBins = this.bins[c].length;
                int zeroY = s.yscale(0.0);
                float xstep = (width + 1.0f) / (float)numBins;
                GeneralPath gp = new GeneralPath();
                gp.moveTo(0.0f, zeroY);
                float lastx = 0.0f;
                float lasty = zeroY;
                for (int i = 0; i < numBins; ++i) {
                    int y = s.yscale(this.bins[c][i]);
                    float x = xstep * (float)i + 0.0f;
                    if (lasty == (float)zeroY && y == zeroY) continue;
                    gp.lineTo(x, y);
                    lastx = x;
                    lasty = y;
                }
                if (lasty != (float)zeroY) {
                    gp.lineTo(lastx, zeroY);
                }
                g2d.setComposite(AlphaComposite.getInstance(3, 0.4f));
                g2d.fill(gp);
                g2d.setComposite(AlphaComposite.SrcOver);
                g2d.draw(gp);
            }
        }
        float step = width / 16.0f;
        for (int i = 0; i < 16; ++i) {
            if (i == this.currentFocusZone) {
                g2d.setColor(Color.yellow);
            } else {
                float color = (float)((Math.pow(2.0, (double)i * 8.0 / 15.0) - 1.0) / 255.0);
                float[] srgbColor = Functions.fromLinearToCS(JAIContext.systemColorSpace, new float[]{color, color, color});
                g2d.setColor(new Color((int)(255.0f * srgbColor[0]), (int)(255.0f * srgbColor[1]), (int)(255.0f * srgbColor[2])));
            }
            g2d.fill(new Rectangle2D.Float(0.0f + step * (float)i, height + 0.0f, step + 0.5f, 18.0f));
        }
    }

    private synchronized void computeHistogram(Rectangle visibleRect, PlanarImage image) {
        int channels = image.getSampleModel().getNumBands();
        Histogram hist = new Histogram(256, 256.0, 512.0, channels);
        this.bins = hist.getBins();
        Rectangle bounds = visibleRect;
        int[] pixel = null;
        int maxPixels = 256;
        int incX = bounds.width >= 2 * maxPixels ? bounds.width / maxPixels : 1;
        int incY = bounds.height >= 2 * maxPixels ? bounds.height / maxPixels : 1;
        double log2 = Math.log(2.0);
        int minTileX = image.XToTileX(bounds.x);
        int maxTileX = image.XToTileX(bounds.x + bounds.width - 1);
        int minTileY = image.YToTileY(bounds.y);
        int maxTileY = image.YToTileY(bounds.y + bounds.height - 1);
        for (int tx = minTileX; tx <= maxTileX; ++tx) {
            for (int ty = minTileY; ty <= maxTileY; ++ty) {
                Raster raster = image.getTile(tx, ty);
                int minX = Math.max(bounds.x, raster.getMinX());
                int maxX = Math.min(bounds.x + bounds.width, raster.getMinX() + raster.getWidth());
                int minY = Math.max(bounds.y, raster.getMinY());
                int maxY = Math.min(bounds.y + bounds.height, raster.getMinY() + raster.getHeight());
                for (int x = minX; x < maxX; x += incX) {
                    for (int y = minY; y < maxY; y += incY) {
                        pixel = raster.getPixel(x, y, pixel);
                        for (int c = 0; c < channels; ++c) {
                            int v = (int)((double)(511.0f * logTable[pixel[c]]) / (16.0 * log2));
                            if (v > 255) {
                                int[] nArray = this.bins[c];
                                int n = v - 256;
                                nArray[n] = nArray[n] + 1;
                                continue;
                            }
                            int[] nArray = this.bins[c];
                            nArray[0] = nArray[0] + 1;
                        }
                    }
                }
            }
        }
        this.bins = hist.getBins();
    }

    @Override
    public void paintDone(PlanarImage image, Rectangle visibleRect, boolean synchronous, long time) {
        Dimension previewDimension = this.getSize();
        if (previewDimension.getHeight() > 1.0 && previewDimension.getWidth() > 1.0) {
            if (this.histogrammer == null || !this.histogrammer.isAlive()) {
                this.histogrammer = new Histogrammer(visibleRect, image);
                this.histogrammer.start();
            } else {
                this.histogrammer.nextView(visibleRect, image);
            }
        }
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            HistogramPreview.logTable[i] = (float)Math.log(i + 1);
        }
    }

    class Histogrammer
    extends Thread {
        PlanarImage image;
        PlanarImage nextImage;
        Rectangle visibleRect;

        Histogrammer(Rectangle visibleRect, PlanarImage image) {
            super("Histogram Preview Histogrammer");
            this.nextImage = null;
            this.visibleRect = visibleRect;
            this.image = image;
        }

        synchronized void nextView(Rectangle visibleRect, PlanarImage image) {
            this.visibleRect = visibleRect;
            this.nextImage = image;
        }

        private synchronized boolean getNextView() {
            if (this.nextImage != null) {
                this.image = this.nextImage;
                this.nextImage = null;
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            do {
                if (HistogramPreview.this.getSize().width <= 0 || HistogramPreview.this.getSize().height <= 0) continue;
                HistogramPreview.this.computeHistogram(this.visibleRect, this.image);
                HistogramPreview.this.repaint();
            } while (this.getNextView());
        }
    }
}

