/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.KernelJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;

public class HiPassFilterOperation
extends BlendedOperation {
    static final OperationType type = new OperationTypeImpl("Hi Pass Filter");
    private double gain = 0.02;
    private double radius = 0.8;
    private KernelJAI kernel = null;

    public HiPassFilterOperation(Rendering rendering) {
        super(rendering, type);
        this.addSliderKey("Gain");
        this.addSliderKey("Radius");
        DecimalFormat format = new DecimalFormat("0.000");
        this.setSliderConfig("Gain", new SliderConfig(0.01, 1.0, this.gain, 0.001, true, format));
        this.setSliderConfig("Radius", new SliderConfig(0.2, 5.0, this.radius, 0.001, true, format));
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key == "Gain" && this.gain != value) {
            this.gain = value;
            this.kernel = null;
        } else if (key == "Radius" && this.radius != value) {
            this.radius = value;
            this.kernel = null;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new HiPassFilter(source);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    private class HiPassFilter
    extends BlendedOperation.BlendedTransform {
        HiPassFilter(PlanarImage source) {
            super(source);
        }

        @Override
        public PlanarImage setFront() {
            HiPassFilterOperation.this.kernel = Functions.LoGSharpenKernel(HiPassFilterOperation.this.radius, HiPassFilterOperation.this.gain);
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            pb.add(HiPassFilterOperation.this.kernel);
            RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            hints.add(JAIContext.noCacheHint);
            return JAI.create((String)"convolve", (ParameterBlock)pb, (RenderingHints)hints);
        }
    }
}

