/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.opimage.FastBilateralFilterOpImage;
import com.lightcrafts.jai.opimage.HDROpImage2;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.KernelJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;

public class HDROperationV3
extends BlendedOperation {
    private double depth = 64.0;
    private double highlights = 0.2;
    private double detail = 1.5;
    private double shadows = 3.0;
    private double fuzz = 0.1;
    private static final String HIGHLIGHTS = "Highlights";
    private static final String DETAIL = "Detail";
    private static final String SHADOWS = "Shadows";
    private static final String DEPTH = "Depth";
    private static final String FUZZ = "Fuzz";
    static final OperationType typeV5 = new OperationTypeImpl("Tone Mapper V5");

    public HDROperationV3(Rendering rendering, OperationType type) {
        super(rendering, type);
        DecimalFormat format = new DecimalFormat("0.00");
        this.addSliderKey(SHADOWS);
        this.setSliderConfig(SHADOWS, new SliderConfig(0.0, 10.0, this.shadows, 0.05, false, format));
        this.addSliderKey(HIGHLIGHTS);
        this.setSliderConfig(HIGHLIGHTS, new SliderConfig(0.0, 1.0, this.highlights, 0.05, false, format));
        this.addSliderKey(DETAIL);
        this.setSliderConfig(DETAIL, new SliderConfig(0.0, 10.0, this.detail, 0.05, false, format));
        this.addSliderKey(DEPTH);
        this.setSliderConfig(DEPTH, new SliderConfig(8.0, 64.0, this.depth, 0.05, false, format));
        this.addSliderKey(FUZZ);
        this.setSliderConfig(FUZZ, new SliderConfig(0.1, 1.0, this.fuzz, 0.05, false, format));
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key == FUZZ && this.fuzz != value) {
            this.fuzz = value;
        } else if (key == DEPTH && this.depth != value) {
            this.depth = value;
        } else if (key == HIGHLIGHTS && this.highlights != value) {
            this.highlights = value;
        } else if (key == DETAIL && this.detail != value) {
            this.detail = value;
        } else if (key == SHADOWS && this.shadows != value) {
            this.shadows = value;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new ToneMaperTransform(source);
    }

    @Override
    public OperationType getType() {
        return this.type;
    }

    private class ToneMaperTransform
    extends BlendedOperation.BlendedTransform {
        SoftReference<PlanarImage> lastBack;
        SoftReference<PlanarImage> mask;
        int mask_count;
        private double last_radius;
        private double last_fuzz;

        ToneMaperTransform(PlanarImage source) {
            super(source);
            this.lastBack = new SoftReference<Object>(null);
            this.mask = new SoftReference<Object>(null);
            this.mask_count = 0;
            this.last_radius = 0.0;
            this.last_fuzz = 0.0;
        }

        @Override
        public PlanarImage setFront() {
            if (this.lastBack.get() != this.back || this.mask.get() == null || HDROperationV3.this.depth != this.last_radius || HDROperationV3.this.fuzz != this.last_fuzz) {
                PlanarImage singleChannel;
                if (this.back.getColorModel().getNumComponents() == 3) {
                    double[][] yChannel = new double[][]{{ColorScience.Wr, ColorScience.Wg, ColorScience.Wb, 0.0}};
                    ParameterBlock pb = new ParameterBlock();
                    pb.addSource(this.back);
                    pb.add(yChannel);
                    singleChannel = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
                } else {
                    singleChannel = this.back;
                }
                BorderExtender copyExtender = BorderExtender.createInstance((int)1);
                RenderingHints extenderHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, copyExtender);
                FastBilateralFilterOpImage maskImage = new FastBilateralFilterOpImage((RenderedImage)singleChannel, JAIContext.fileCacheHint, (float)(HDROperationV3.this.depth * (double)HDROperationV3.this.scale), 0.1f);
                ParameterBlock pb = new ParameterBlock();
                pb.addSource((Object)maskImage);
                pb.add(new int[]{0});
                RenderedOp bfMask = JAI.create((String)"bandselect", (ParameterBlock)pb, null);
                KernelJAI kernel = Functions.getGaussKernel(10.0 * HDROperationV3.this.fuzz * (double)HDROperationV3.this.scale);
                pb = new ParameterBlock();
                pb.addSource(bfMask);
                pb.add(kernel);
                RenderedOp blurredMask = JAI.create((String)"LCSeparableConvolve", (ParameterBlock)pb, (RenderingHints)extenderHints);
                pb = new ParameterBlock();
                pb.addSource((Object)maskImage);
                pb.addSource(blurredMask);
                maskImage = JAI.create((String)"BandMerge", (ParameterBlock)pb, null);
                this.last_radius = HDROperationV3.this.fuzz;
                this.last_fuzz = HDROperationV3.this.detail;
                this.mask = new SoftReference<FastBilateralFilterOpImage>(maskImage);
                this.lastBack = new SoftReference<PlanarImage>(this.back);
            }
            return new HDROpImage2((RenderedImage)this.back, (RenderedImage)this.mask.get(), HDROperationV3.this.shadows, HDROperationV3.this.highlights, HDROperationV3.this.detail, null);
        }
    }
}

