/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.LookupTableJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.ImageProcessor;
import com.lightcrafts.model.ImageEditor.LayerModeImpl;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.LayerConfig;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;

public class HDROperation
extends BlendedOperation {
    private double radius = 250.0;
    private double gamma = 2.2;
    private double detail = 0.8;
    private short[] tableDataUShort = new short[65536];
    private byte[] tableDataByte = new byte[256];
    private LookupTableJAI byteLut = null;
    private LookupTableJAI ushortLut = null;
    private static final String RADIUS = "Radius";
    private static final String GAMMA = "Gamma";
    private static final String DETAIL = "Detail";
    static final OperationType type = new OperationTypeImpl("Tone Mapper");
    private DesaturateInvertProcessor desaturateInvert = new DesaturateInvertProcessor();

    public HDROperation(Rendering rendering, OperationType type) {
        super(rendering, type);
        DecimalFormat format = new DecimalFormat("0.00");
        this.addSliderKey(RADIUS);
        this.setSliderConfig(RADIUS, new SliderConfig(100.0, 500.0, this.radius, 10.0, true, format));
        this.addSliderKey(GAMMA);
        this.setSliderConfig(GAMMA, new SliderConfig(0.1, 10.0, this.gamma, 0.1, true, format));
        this.addSliderKey(DETAIL);
        this.setSliderConfig(DETAIL, new SliderConfig(0.0, 1.0, this.detail, 0.1, false, format));
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key == RADIUS && this.radius != value) {
            this.radius = value;
        } else if (key == GAMMA && this.gamma != value) {
            this.gamma = value;
            this.byteLut = null;
            this.ushortLut = null;
        } else if (key == DETAIL && this.detail != value) {
            this.detail = value;
        } else {
            return;
        }
        super.setSliderValue(key, value);
    }

    private LookupTableJAI computeGammaTable(int dataType) {
        if (dataType == 0) {
            if (this.byteLut != null) {
                return this.byteLut;
            }
            for (int i = 0; i < this.tableDataByte.length; ++i) {
                this.tableDataByte[i] = (byte)(255.0 * Math.pow((double)i / 255.0, this.gamma) + 0.5);
            }
            this.byteLut = new LookupTableJAI(this.tableDataByte);
            return this.byteLut;
        }
        if (this.ushortLut != null) {
            return this.ushortLut;
        }
        for (int i = 0; i < this.tableDataUShort.length; ++i) {
            this.tableDataUShort[i] = (short)(65535.0 * Math.pow((double)i / 65535.0, this.gamma) + 0.5);
        }
        this.ushortLut = new LookupTableJAI(this.tableDataUShort, true);
        return this.ushortLut;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new ToneMaperTransform(source, this);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    @Override
    public LayerConfig getDefaultLayerConfig() {
        return new LayerConfig(new LayerModeImpl("Soft Light"), 0.75);
    }

    private class ToneMaperTransform
    extends BlendedOperation.BlendedTransform {
        Operation op;

        ToneMaperTransform(PlanarImage source, Operation op) {
            super(source);
            this.op = op;
        }

        @Override
        public PlanarImage setFront() {
            RenderedOp front = Functions.gaussianBlur((RenderedImage)this.back, HDROperation.this.rendering, this.op, HDROperation.this.desaturateInvert, HDROperation.this.radius * (double)HDROperation.this.scale);
            if (HDROperation.this.detail > 0.0) {
                PlanarImage singleChannel;
                if (this.back.getColorModel().getNumComponents() == 3) {
                    double[][] yChannel = new double[][]{{ColorScience.Wr, ColorScience.Wg, ColorScience.Wb, 0.0}};
                    ParameterBlock pb = new ParameterBlock();
                    pb.addSource(this.back);
                    pb.add(yChannel);
                    singleChannel = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
                } else {
                    singleChannel = this.back;
                }
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(singleChannel);
                pb.add(2.0f * HDROperation.this.scale);
                pb.add(20.0f);
                RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                RenderedOp bilateral = JAI.create((String)"BilateralFilter", (ParameterBlock)pb, (RenderingHints)hints);
                pb = new ParameterBlock();
                pb.addSource(bilateral);
                pb.addSource(front);
                pb.add("Overlay");
                pb.add(HDROperation.this.detail);
                front = JAI.create((String)"Blend", (ParameterBlock)pb, null);
            }
            return front;
        }
    }

    class DesaturateInvertProcessor
    implements ImageProcessor {
        DesaturateInvertProcessor() {
        }

        @Override
        public RenderedOp process(RenderedImage source) {
            RenderedImage singleChannel;
            if (source.getColorModel().getNumComponents() == 3) {
                double[][] yChannel = new double[][]{{ColorScience.Wr, ColorScience.Wg, ColorScience.Wb, 0.0}};
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(source);
                pb.add(yChannel);
                singleChannel = JAI.create((String)"BandCombine", (ParameterBlock)pb, null);
            } else {
                singleChannel = source;
            }
            RenderedOp invert = JAI.create((String)"Not", (RenderedImage)singleChannel, (Object)JAIContext.noCacheHint);
            LookupTableJAI table = HDROperation.this.computeGammaTable(invert.getColorModel().getTransferType());
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(invert);
            pb.add(table);
            return JAI.create((String)"lookup", (ParameterBlock)pb, null);
        }
    }
}

