/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.IHSColorSpace;
import com.lightcrafts.model.ImageEditor.ImageEditorEngine;
import com.lightcrafts.model.Preview;
import com.lightcrafts.model.Region;
import com.lightcrafts.ui.toolkit.ShadowFactory;
import com.lightcrafts.utils.ColorScience;
import com.lightcrafts.utils.LCMS;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;

class DropperPreview
extends Preview {
    private ImageEditorEngine engine;
    private Point loc = new Point(0, 0);
    private Color color = Color.GRAY;
    private static IHSColorSpace ihsCS = IHSColorSpace.getInstance();
    private static final RenderingHints aliasingRenderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    DropperPreview(ImageEditorEngine engine) {
        this.engine = engine;
    }

    @Override
    public String getName() {
        return "Sampler";
    }

    @Override
    public void setDropper(Point p) {
        if (p != null && this.engine != null) {
            Color sample = this.engine.getPixelValue(p.x, p.y);
            if (sample != null) {
                this.loc = p;
                this.color = sample;
            }
            this.repaint();
        }
    }

    @Override
    public void setRegion(Region region) {
    }

    @Override
    public void setSelected(Boolean selected) {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHints(aliasingRenderHints);
        Dimension bounds = this.getSize();
        boolean minx = false;
        boolean miny = false;
        int width = bounds.width;
        int height = bounds.height;
        int gap = width - 130;
        g.setColor(new Color(245, 245, 245));
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        Font font = new Font("Monospaced", 0, 12);
        g.setFont(font);
        TextLayout layout = new TextLayout("ABC", font, g.getFontRenderContext());
        float textHeight = (float)layout.getBounds().getHeight() + 5.0f;
        if (this.loc != null && this.engine != null) {
            g.drawString("    x: " + this.loc.x, 10.0f, 2.0f + textHeight);
            g.drawString("    y: " + this.loc.y, 10.0f, 2.0f + 2.0f * textHeight);
            int red = this.color.getRed();
            int green = this.color.getGreen();
            int blue = this.color.getBlue();
            g.drawString("  Red: " + red, 10.0f, 12.0f + 3.0f * textHeight);
            g.drawString("Green: " + green, 10.0f, 12.0f + 4.0f * textHeight);
            g.drawString(" Blue: " + blue, 10.0f, 12.0f + 5.0f * textHeight);
            double lightness = ColorScience.Wr * (float)red + ColorScience.Wg * (float)green + ColorScience.Wb * (float)blue;
            g.drawString("Luminosity: " + (int)lightness, (float)(0 + gap), 2.0f + textHeight);
            double zone = Math.log(lightness) / (8.0 * Math.log(2.0));
            DecimalFormat format = new DecimalFormat("0.0");
            g.drawString("      Zone: " + format.format(10.0 * zone), (float)(0 + gap), 2.0f + 2.0f * textHeight);
            float[] xyzColor = JAIContext.linearColorSpace.toCIEXYZ(new float[]{(float)((double)red / 255.0), (float)((double)green / 255.0), (float)((double)blue / 255.0)});
            float[] ihsColor = ihsCS.fromCIEXYZ(xyzColor);
            g.drawString(" Intensity: " + (int)(100.0f * ihsColor[0]) + "%", (float)(0 + gap), 12.0f + 3.0f * textHeight);
            g.drawString("       Hue: " + (int)(360.0 * ((double)ihsColor[1] / (Math.PI * 2))) + "\u00b0", (float)(0 + gap), 12.0f + 4.0f * textHeight);
            g.drawString("Saturation: " + (int)(100.0f * ihsColor[2]) + "%", (float)(0 + gap), 12.0f + 5.0f * textHeight);
            LCMS.Transform ts = new LCMS.Transform(new LCMS.Profile(JAIContext.linearProfile), LCMS.TYPE_RGB_16, new LCMS.Profile(JAIContext.labProfile), LCMS.TYPE_Lab_16, 1, 0);
            short[] labColors = new short[3];
            ts.doTransform(new short[]{(short)(red * 256), (short)(green * 256), (short)(blue * 256)}, labColors);
            int L = 100 * (0xFFFF & labColors[0]) / 65535;
            int a = ((0xFFFF & labColors[1]) - 32768) / 256;
            int b = ((0xFFFF & labColors[2]) - 32768) / 256;
            g.drawString("    L: " + L, 10.0f, 12.0f + 7.0f * textHeight);
            g.drawString("    a: " + a, 10.0f, 12.0f + 8.0f * textHeight);
            g.drawString("    b: " + b, 10.0f, 12.0f + 9.0f * textHeight);
            float[] components = this.color.getRGBComponents(null);
            components = Functions.fromLinearToCS(JAIContext.systemColorSpace, components);
            Dimension size = new Dimension(width - 20, 60);
            BufferedImage image = new BufferedImage(size.width - 106, size.height - 6, 1);
            Graphics imageG = image.getGraphics();
            imageG.setColor(new Color(components[0], components[1], components[2]));
            imageG.fillRect(0, 0, size.width - 106, size.height - 6);
            imageG.dispose();
            ShadowFactory shadow = new ShadowFactory(3, 1.0f, Color.gray);
            shadow.setRenderingHint("blur_quality", "high");
            BufferedImage shadowImage = shadow.createShadow(image);
            imageG = shadowImage.getGraphics();
            imageG.drawImage(image, 3, 2, null);
            imageG.dispose();
            graphics.drawImage(shadowImage, 110, (int)(12.0f + 6.0f * textHeight), null);
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawRect(112, (int)(12.0f + 6.0f * textHeight) + 2, size.width - 106, size.height - 6);
        }
    }

    static {
        aliasingRenderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        aliasingRenderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }
}

