/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model;

public class ColorSelection {
    public final float hueLower;
    public final float hueUpper;
    public final float hueLowerFeather;
    public final float hueUpperFeather;
    public final float luminosityLower;
    public final float luminosityUpper;
    public final float luminosityLowerFeather;
    public final float luminosityUpperFeather;
    public final boolean isHueEnabled;
    public final boolean isLuminosityEnabled;

    public ColorSelection(float hueLower, float hueLowerFeather, float hueUpper, float hueUpperFeather, float brightnessLower, float brightnessLowerFeather, float brightnessUpper, float brightnessUpperFeather, boolean isHueEnabled, boolean isBrightnessEnabled) {
        if (hueLower > hueUpper || brightnessLower > brightnessUpper) {
            throw new IllegalArgumentException();
        }
        this.hueLower = hueLower;
        this.hueUpper = hueUpper;
        this.hueLowerFeather = hueLowerFeather;
        this.hueUpperFeather = hueUpperFeather;
        this.luminosityLower = brightnessLower;
        this.luminosityUpper = brightnessUpper;
        this.luminosityLowerFeather = brightnessLowerFeather;
        this.luminosityUpperFeather = brightnessUpperFeather;
        this.isHueEnabled = isHueEnabled;
        this.isLuminosityEnabled = isBrightnessEnabled;
    }

    public ColorSelection() {
        this(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, true, true);
    }

    public boolean isAllSelected() {
        return (this.hueLowerFeather == 0.0f && this.hueUpperFeather == 0.0f && this.hueUpper - this.hueLower == 1.0f || !this.isHueEnabled) && (this.luminosityLowerFeather == 0.0f && this.luminosityUpperFeather == 0.0f && this.luminosityUpper - this.luminosityLower == 1.0f || !this.isLuminosityEnabled);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("brightness ([");
        buffer.append(this.luminosityLower);
        buffer.append(" +/- ");
        buffer.append(this.luminosityLowerFeather);
        buffer.append("] -> [");
        buffer.append(this.luminosityUpper);
        buffer.append(" +/- ");
        buffer.append(this.luminosityUpperFeather);
        buffer.append("]); hue ([");
        buffer.append(this.hueLower);
        buffer.append(" +/- ");
        buffer.append(this.hueLowerFeather);
        buffer.append("] -> [");
        buffer.append(this.hueUpper);
        buffer.append(" +/- ");
        buffer.append(this.hueUpperFeather);
        buffer.append("])");
        buffer.append(" hue=");
        buffer.append(this.isHueEnabled);
        buffer.append(" brightness=");
        buffer.append(this.isLuminosityEnabled);
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorSelection that = (ColorSelection)o;
        if (that.luminosityLower != this.luminosityLower) {
            return false;
        }
        if (that.luminosityLowerFeather != this.luminosityLowerFeather) {
            return false;
        }
        if (that.luminosityUpper != this.luminosityUpper) {
            return false;
        }
        if (that.luminosityUpperFeather != this.luminosityUpperFeather) {
            return false;
        }
        if (that.hueLower != this.hueLower) {
            return false;
        }
        if (that.hueLowerFeather != this.hueLowerFeather) {
            return false;
        }
        if (that.hueUpper != this.hueUpper) {
            return false;
        }
        if (that.hueUpperFeather != this.hueUpperFeather) {
            return false;
        }
        if (this.isLuminosityEnabled != that.isLuminosityEnabled) {
            return false;
        }
        return this.isHueEnabled == that.isHueEnabled;
    }
}

