/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.license;

import com.lightcrafts.license.ESDLicenseCheckerModule;
import com.lightcrafts.license.ESDLicenseLibrary;
import com.lightcrafts.license.ESDLicenseManager;
import com.lightcrafts.license.Locale;
import com.lightcrafts.license.eSellerateLicenseDialogs;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.platform.ProgressDialog;
import com.lightcrafts.utils.LCArrays;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.WebBrowser;
import com.lightcrafts.utils.bytebuffer.ByteBufferUtil;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

final class eSellerateLicenseLibrary
implements ESDLicenseLibrary {
    private static final int ES_NO_ERROR = 0;
    private static final int LC_INVALID_LICENSE_FILE = 5003777;
    private static final int LC_INVALID_LICENSE_KEY = 4999682;
    private static final int LC_WRITE_LICENSE_KEY_FAILED = 5003779;
    private static final String SALT = "0bc4717102ccf6009a1286ba46aaa8c0";
    private String m_licenseKey;
    private ESDLicenseLibrary.LicenseType m_licenseType;
    private long m_trialLicenseStart;
    private static final String LICENSE_KEY_PATTERN_STRING = "\\w{10}(?:-[A-HJ-NP-TV-Y0-9]{4}){5}";
    private static final Pattern LICENSE_KEY_PATTERN = Pattern.compile("\\w{10}(?:-[A-HJ-NP-TV-Y0-9]{4}){5}");
    private static final String LZ3_LICENSE_FILE_SUFFIX = "3";
    private static final long TRIAL_EXTENSION_DURATION = 604800L;
    private static final int OLD_TRIAL_LICENSE_SIZE = 5;
    private static final int TRIAL_LICENSE_SIZE = 7;
    private static final ResourceBundle m_properties = ResourceBundle.getBundle("com.lightcrafts.license.resources.eSellerate");

    eSellerateLicenseLibrary() {
    }

    @Override
    public ESDLicenseLibrary.ESDError activateKey(String key) {
        ProgressDialog pd = Platform.getPlatform().getProgressDialog();
        ActivateThread at = new ActivateThread(pd, key, true);
        pd.showProgress(null, at, Locale.LOCALE.get("ActivatingSerialNumberMessage"), false);
        Throwable t = pd.getThrown();
        if (t != null) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        if (at.m_errorCode != 0) {
            return new eSellerateError(at.m_errorCode);
        }
        return NO_ESD_ERROR;
    }

    @Override
    public ESDLicenseLibrary.ESDError buyNow() {
        WebBrowser.browse(m_properties.getString("BuyNowURL"));
        return NO_ESD_ERROR;
    }

    @Override
    public ESDLicenseLibrary.ESDError deactivateKey(String key) {
        ProgressDialog pd = Platform.getPlatform().getProgressDialog();
        ActivateThread at = new ActivateThread(pd, key, false);
        pd.showProgress(null, at, Locale.LOCALE.get("DeactivatingSerialNumberMessage"), false);
        Throwable t = pd.getThrown();
        if (t != null) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        if (at.m_errorCode != 0) {
            return new eSellerateError(at.m_errorCode);
        }
        eSellerateLicenseLibrary.getLicenseFileFor("LightZone-RT", null).delete();
        try {
            eSellerateLicenseLibrary.writeTrialLicenseFile(0L);
            return NO_ESD_ERROR;
        }
        catch (IOException e) {
            return new eSellerateError(5003779);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getErrorMessage(ESDLicenseLibrary.ESDError error) {
        int errorCode = ((eSellerateError)error).m_errorCode;
        String msg = eSellerateLicenseLibrary.ESgetErrorMessage(errorCode);
        if (msg == null) {
            return Locale.LOCALE.get("UnknownError", errorCode);
        }
        if (msg.startsWith("LOCALIZED:")) {
            return msg.substring(10);
        }
        return Locale.LOCALE.get(msg);
    }

    @Override
    public String getLicenseKey() {
        return this.m_licenseKey;
    }

    @Override
    public Pattern getLicenseKeyPattern() {
        return LICENSE_KEY_PATTERN;
    }

    @Override
    public ESDLicenseLibrary.LicenseType getLicenseType() {
        return this.m_licenseType;
    }

    @Override
    public Date getTrialLicenseExpirationDate() {
        if (this.m_licenseType != ESDLicenseLibrary.LicenseType.LICENSE_TRIAL) {
            return null;
        }
        if (this.m_trialLicenseStart * 1000L > ESDLicenseCheckerModule.trialLicenseRefDate.getTime()) {
            return new Date(0L);
        }
        long expiration = this.m_trialLicenseStart + 2592000L;
        return new Date(expiration * 1000L);
    }

    @Override
    public ESDLicenseLibrary.ESDError initialize() {
        int errorCode = eSellerateLicenseLibrary.ESinitialize();
        if (errorCode != 0) {
            return new eSellerateError(errorCode);
        }
        return NO_ESD_ERROR;
    }

    @Override
    public boolean isBasicKey(String key) {
        return eSellerateLicenseLibrary.isKey3Basic(key);
    }

    @Override
    public boolean isKeyActivated(String key) {
        int errorCode = eSellerateLicenseLibrary.ESvalidateActivation(key);
        return errorCode == 0;
    }

    @Override
    public boolean isKeyValid(String key) {
        byte[] buf;
        if (!key.startsWith("LZ3") || !eSellerateLicenseLibrary.isKeyValidImpl(key)) {
            return false;
        }
        if (!eSellerateLicenseLibrary.isKeyForUpgrade(key)) {
            return true;
        }
        if (this.getLicenseType() == ESDLicenseLibrary.LicenseType.LICENSE_NORMAL) {
            return !eSellerateLicenseLibrary.isKey3Basic(this.getLicenseKey()) || eSellerateLicenseLibrary.isKeyAnyBasicUpgradeToBasic(key) || eSellerateLicenseLibrary.isKeyAnyBasicUpgradeToFull(key);
        }
        try {
            File licenseFile = eSellerateLicenseLibrary.getLicenseFile(true, null);
            buf = eSellerateLicenseLibrary.readLicenseFile(licenseFile);
        }
        catch (IOException e) {
            return false;
        }
        if (buf == null || buf[0] != 78) {
            return false;
        }
        String oldKey = eSellerateLicenseLibrary.decodeNormalLicense(buf);
        if (eSellerateLicenseLibrary.isKeyPre3Basic(oldKey) && eSellerateLicenseLibrary.isKeyPre3FullUpgradeToFull(key)) {
            return false;
        }
        return eSellerateLicenseLibrary.isKeyValidImpl(oldKey);
    }

    @Override
    public boolean isInternetError(ESDLicenseLibrary.ESDError error) {
        if (error instanceof eSellerateError) {
            return eSellerateLicenseLibrary.ESisInternetError(((eSellerateError)error).m_errorCode);
        }
        return false;
    }

    @Override
    public ESDLicenseLibrary.ESDError manuallyActivateKey(String key) {
        int errorCode = eSellerateLicenseLibrary.ESmanualActivateSerialNumber(key);
        if (errorCode != 0) {
            return new eSellerateError(errorCode);
        }
        return NO_ESD_ERROR;
    }

    @Override
    public ESDLicenseLibrary.ESDError probeLicenseType() {
        byte[] buf;
        System.err.println("probeLicenseType()");
        this.m_licenseType = ESDLicenseLibrary.LicenseType.LICENSE_INVALID;
        try {
            File licenseFile = eSellerateLicenseLibrary.getLicenseFile(true, LZ3_LICENSE_FILE_SUFFIX);
            buf = eSellerateLicenseLibrary.readLicenseFile(licenseFile);
        }
        catch (IOException e) {
            return new eSellerateError(5003777);
        }
        if (buf == null) {
            return NO_ESD_ERROR;
        }
        block2 : switch (buf[0]) {
            case 84: {
                System.err.println("  trial license");
                switch (buf.length) {
                    case 7: {
                        ByteBuffer bb = ByteBuffer.wrap(buf);
                        bb.order(ByteOrder.nativeOrder());
                        bb.get();
                        this.m_trialLicenseStart = bb.getInt();
                        this.m_licenseType = ESDLicenseLibrary.LicenseType.LICENSE_TRIAL;
                        break block2;
                    }
                    case 5: {
                        System.err.println("  extending trial license");
                        this.m_trialLicenseStart = System.currentTimeMillis() / 1000L - 2592000L + 604800L;
                        try {
                            eSellerateLicenseLibrary.writeTrialLicenseFile(this.m_trialLicenseStart);
                        }
                        catch (IOException e) {
                            return new eSellerateError(5003779);
                        }
                        this.m_licenseType = ESDLicenseLibrary.LicenseType.LICENSE_TRIAL;
                        break block2;
                    }
                }
                System.err.println("bad byte-count");
                return new eSellerateError(5003777);
            }
            case 78: {
                this.m_licenseKey = eSellerateLicenseLibrary.decodeNormalLicense(buf);
                this.m_licenseType = ESDLicenseLibrary.LicenseType.LICENSE_NORMAL;
                System.err.println("  normal license: key = \"" + this.m_licenseKey + '\"');
                break;
            }
            default: {
                System.err.println("  unknown license type: " + buf[0]);
                return new eSellerateError(5003777);
            }
        }
        return NO_ESD_ERROR;
    }

    @Override
    public ESDLicenseLibrary.ESDError requestLicense() {
        return NO_ESD_ERROR;
    }

    @Override
    public boolean saveLicenseKey(String key) {
        System.err.println("saveLicenseKey()");
        byte[] normalLicenseBuf = eSellerateLicenseLibrary.encodeNormalLicense(key);
        try {
            eSellerateLicenseLibrary.writeLicenseFile(normalLicenseBuf);
            this.m_licenseKey = key;
            this.m_licenseType = ESDLicenseLibrary.LicenseType.LICENSE_NORMAL;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public ESDLicenseLibrary.ESDError tryNow(String key) {
        System.err.println("tryNow()");
        try {
            eSellerateLicenseLibrary.writeTrialLicenseFile(System.currentTimeMillis() / 1000L);
            return NO_ESD_ERROR;
        }
        catch (IOException e) {
            return new eSellerateError(5003779);
        }
    }

    private static boolean isKeyAnyBasicUpgradeToBasic(String key) {
        return key.startsWith("LZ3UBB");
    }

    private static boolean isKeyAnyBasicUpgradeToFull(String key) {
        return key.startsWith("LZ3UBF");
    }

    private static boolean isKey3Basic(String key) {
        return key.startsWith("LZ3B") || key.startsWith("LZ3UBB");
    }

    private static boolean isKeyPre3Basic(String key) {
        return key.startsWith("LZRT");
    }

    private static boolean isKeyPre3FullUpgradeToFull(String key) {
        return key.startsWith("LZ3UF");
    }

    private static native int ESactivateSerialNumber(String var0);

    private static native int ESdeactivateSerialNumber(String var0);

    private static native String ESgetErrorMessage(int var0);

    private static native int ESinitialize();

    private static native boolean ESisInternetError(int var0);

    private static native int ESmanualActivateSerialNumber(String var0);

    private static native int ESvalidateActivation(String var0);

    private static native int ESvalidateSerialNumber(String var0);

    private static String decodeNormalLicense(byte[] buf) {
        eSellerateLicenseLibrary.transcode(buf, 1, buf.length - 1);
        try {
            return new String(buf, 1, buf.length - 2, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static byte[] encodeNormalLicense(String key) {
        byte[] buf = new byte[1 + key.length() + 1];
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.put((byte)78);
        ByteBufferUtil.put(bb, key, "ASCII");
        bb.put((byte)0);
        eSellerateLicenseLibrary.transcode(buf, 1, key.length() + 1);
        return buf;
    }

    private static byte[] encodeTrialLicense(long startTime) {
        byte[] buf = new byte[7];
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.order(ByteOrder.nativeOrder());
        bb.put((byte)84);
        bb.putInt((int)startTime);
        bb.putShort((short)Version.getRevisionNumber());
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getLicenseFile(boolean checkForRT, String suffix) throws IOException {
        File licenseDir;
        File licenseFile = eSellerateLicenseLibrary.getLicenseFileFor(Version.getApplicationName(), suffix);
        if (!licenseFile.exists() && checkForRT) {
            File rtLicenseFile = eSellerateLicenseLibrary.getLicenseFileFor("LightZone-RT", null);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(rtLicenseFile);
                byte[] licenseBuf = new byte[1];
                int bytesRead = fis.read(licenseBuf);
                if (bytesRead != 0 && licenseBuf[0] == 78) {
                    licenseFile = rtLicenseFile;
                }
            }
            catch (IOException e) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (!(licenseDir = licenseFile.getParentFile()).exists() && !licenseDir.mkdirs()) {
            System.err.println("  couldn't get license file");
            throw new IOException("Could not create license folder.");
        }
        System.err.println("  license file = \"" + licenseFile + '\"');
        return licenseFile;
    }

    private static File getLicenseFileFor(String appName, String suffix) {
        StringBuilder sb = new StringBuilder();
        if (Platform.getType() == Platform.Windows) {
            sb.append(System.getenv("APPDATA"));
        } else {
            sb.append(System.getProperty("user.home"));
            sb.append("/Library/Application Support");
        }
        sb.append(File.separatorChar);
        sb.append(appName);
        sb.append(File.separatorChar);
        sb.append("License");
        sb.append(File.separatorChar);
        sb.append("ESLF");
        if (suffix != null) {
            sb.append(suffix);
        }
        return new File(sb.toString());
    }

    private static boolean isKeyForUpgrade(String key) {
        return key.startsWith("LZ3U");
    }

    private static boolean isKeyValidImpl(String key) {
        int errorCode = eSellerateLicenseLibrary.ESvalidateSerialNumber(key);
        return errorCode == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readLicenseFile(File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] licenseBuf = new byte[64];
            int bytesRead = fis.read(licenseBuf);
            System.err.println("  bytes read = " + bytesRead);
            if (bytesRead != 0) {
                byte[] byArray = (byte[])LCArrays.resize(licenseBuf, bytesRead);
                return byArray;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return null;
    }

    private static void transcode(byte[] buf, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            int n = i + offset;
            buf[n] = (byte)(buf[n] ^ SALT.charAt(i % SALT.length()));
        }
    }

    private static void writeLicenseFile(byte[] licenseBuf) throws IOException {
        IOException caughtException;
        File licenseFile;
        block5: {
            System.err.println("writeLicenseFile()");
            licenseFile = eSellerateLicenseLibrary.getLicenseFile(false, LZ3_LICENSE_FILE_SUFFIX);
            FileOutputStream fos = new FileOutputStream(licenseFile);
            caughtException = null;
            try {
                fos.write(licenseBuf);
            }
            catch (IOException e) {
                caughtException = e;
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                if (caughtException != null) break block5;
                caughtException = e;
            }
        }
        if (caughtException != null) {
            System.err.println("  write failed; removing now-bad license file");
            licenseFile.delete();
            throw caughtException;
        }
        System.err.println("  write succeeded");
    }

    static void writeTrialLicenseFile(long startTime) throws IOException {
        System.err.println("writeTrialLicenseFile()");
        byte[] trialLicenseBuf = eSellerateLicenseLibrary.encodeTrialLicense(startTime);
        eSellerateLicenseLibrary.writeLicenseFile(trialLicenseBuf);
    }

    public static void main(String[] args) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    eSellerateLicenseLibrary lib = new eSellerateLicenseLibrary();
                    eSellerateLicenseDialogs dialogs = new eSellerateLicenseDialogs();
                    if (ESDLicenseManager.getLicense(lib, dialogs)) {
                        // empty if block
                    }
                    lib.dispose();
                    System.exit(0);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        System.loadLibrary("ESD");
    }

    private static final class eSellerateError
    extends ESDLicenseLibrary.ESDError {
        private int m_errorCode;

        eSellerateError(int errorCode) {
            this.m_errorCode = errorCode;
        }
    }

    private static final class ActivateThread
    extends ProgressThread {
        int m_errorCode;
        private final boolean m_activate;
        private final String m_key;

        ActivateThread(ProgressIndicator indicator, String key, boolean activate) {
            super(indicator);
            this.m_activate = activate;
            this.m_key = key;
        }

        @Override
        public void run() {
            this.m_errorCode = this.m_activate ? eSellerateLicenseLibrary.ESactivateSerialNumber(this.m_key) : eSellerateLicenseLibrary.ESdeactivateSerialNumber(this.m_key);
        }
    }
}

