/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.license;

import com.lightcrafts.license.ESDLicenseDialogs;
import com.lightcrafts.license.ESDLicenseLibrary;
import com.lightcrafts.license.LicenseChecker;
import com.lightcrafts.license.Locale;
import com.lightcrafts.platform.AlertDialog;
import com.lightcrafts.platform.Platform;
import java.util.Date;
import java.util.regex.Pattern;

final class ESDLicenseManager {
    static final long TRIAL_LICENSE_DURATION = 2592000L;

    ESDLicenseManager() {
    }

    static boolean getLicense(ESDLicenseLibrary lib, ESDLicenseDialogs dialogs) {
        boolean badKey = false;
        block15: while (true) {
            ESDLicenseLibrary.ESDError error;
            if ((error = lib.probeLicenseType()) != ESDLicenseLibrary.NO_ESD_ERROR) {
                dialogs.showErrorAlert(lib.getErrorMessage(error), true);
                return false;
            }
            ESDLicenseLibrary.LicenseType licenseType = badKey ? ESDLicenseLibrary.LicenseType.LICENSE_INVALID : lib.getLicenseType();
            block0 : switch (licenseType) {
                case LICENSE_NORMAL: {
                    String key = lib.getLicenseKey();
                    if (ESDLicenseManager.isKeyValid(key, lib, dialogs) && ESDLicenseManager.activateKey(key, lib, dialogs)) break;
                    badKey = true;
                    continue block15;
                }
                case LICENSE_TRIAL: {
                    Date expiration = lib.getTrialLicenseExpirationDate();
                    switch (dialogs.showTrialExpirationDialog(expiration)) {
                        case ESD_BUY_NOW: {
                            lib.buyNow();
                            continue block15;
                        }
                        case ESD_CONTINUE_TRIAL: {
                            break block0;
                        }
                        case ESD_ENTER_KEY: {
                            if (!ESDLicenseManager.enterAndValidateKey(lib, dialogs)) continue block15;
                            badKey = false;
                            break block0;
                        }
                        case ESD_QUIT: {
                            return false;
                        }
                    }
                    throw new IllegalStateException();
                }
                default: {
                    switch (dialogs.showUnlicensedDialog()) {
                        case ESD_ENTER_KEY: {
                            if (!ESDLicenseManager.enterAndValidateKey(lib, dialogs)) continue block15;
                            badKey = false;
                            break block0;
                        }
                        case ESD_TRY_NOW: {
                            if (ESDLicenseManager.tryNow(lib, dialogs)) break block0;
                            continue block15;
                        }
                        case ESD_QUIT: {
                            return false;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            }
            if ((error = lib.requestLicense()) == ESDLicenseLibrary.NO_ESD_ERROR) break;
            dialogs.showErrorAlert(lib.getErrorMessage(error), false);
        }
        return true;
    }

    static boolean relicense(ESDLicenseLibrary lib, ESDLicenseDialogs dialogs) {
        String key;
        LicenseChecker.m_enteredLicenseKey = false;
        Pattern keyPattern = lib.getLicenseKeyPattern();
        do {
            if ((key = dialogs.showEnterKeyDialog(keyPattern)) != null) continue;
            return false;
        } while (!ESDLicenseManager.isKeyValid(key, lib, dialogs) || !ESDLicenseManager.activateKey(key, lib, dialogs) || !ESDLicenseManager.saveKey(key, lib, dialogs));
        LicenseChecker.m_enteredLicenseKey = true;
        return true;
    }

    static boolean unlicense(ESDLicenseLibrary lib, ESDLicenseDialogs dialogs) {
        if (!dialogs.showDeactivateDialog()) {
            return false;
        }
        ESDLicenseLibrary.ESDError error = lib.deactivateKey(lib.getLicenseKey());
        if (error != ESDLicenseLibrary.NO_ESD_ERROR) {
            dialogs.showErrorAlert(lib.getErrorMessage(error), false);
            return false;
        }
        Platform.getPlatform().getAlertDialog().showAlert(null, Locale.LOCALE.get("DeactivationSucceededMajor"), Locale.LOCALE.get("DeactivationSucceededMinor"), 1, Locale.LOCALE.get("QuitButton"));
        return true;
    }

    static boolean enterAndValidateKey(ESDLicenseLibrary lib, ESDLicenseDialogs dialogs) {
        LicenseChecker.m_enteredLicenseKey = false;
        Pattern keyPattern = lib.getLicenseKeyPattern();
        String key = dialogs.showEnterKeyDialog(keyPattern);
        LicenseChecker.m_enteredLicenseKey = key != null && ESDLicenseManager.isKeyValid(key, lib, dialogs) && ESDLicenseManager.activateKey(key, lib, dialogs) && ESDLicenseManager.saveKey(key, lib, dialogs);
        return LicenseChecker.m_enteredLicenseKey;
    }

    private static boolean activateKey(String key, ESDLicenseLibrary lib, ESDLicenseDialogs dialogs) {
        if (!lib.isKeyActivated(key)) {
            ESDLicenseLibrary.ESDError error = lib.activateKey(key);
            if (lib.isInternetError(error)) {
                error = lib.manuallyActivateKey(key);
            }
            if (error != ESDLicenseLibrary.NO_ESD_ERROR) {
                dialogs.showErrorAlert(lib.getErrorMessage(error), false);
                return false;
            }
        }
        return true;
    }

    private static boolean isKeyValid(String key, ESDLicenseLibrary lib, ESDLicenseDialogs dialogs) {
        if (lib.isKeyValid(key)) {
            return true;
        }
        if (key.startsWith("0101605001") || key.startsWith("LZRT") || key.startsWith("LZ2")) {
            AlertDialog dialog = Platform.getPlatform().getAlertDialog();
            int button = dialog.showAlert(null, Locale.LOCALE.get("Pre3SNErrorMajor"), Locale.LOCALE.get("Pre3SNErrorMinor"), 2, Locale.LOCALE.get("BuyNowButton"), Locale.LOCALE.get("CancelButton"));
            if (button == 0) {
                lib.buyNow();
            }
        } else {
            dialogs.showErrorAlert(Locale.LOCALE.get("InvalidSNError"), false);
        }
        return false;
    }

    private static boolean saveKey(String key, ESDLicenseLibrary lib, ESDLicenseDialogs dialogs) {
        if (!lib.saveLicenseKey(key)) {
            dialogs.showErrorAlert(Locale.LOCALE.get("LC_WRITE_LICENSE_KEY_FAILED"), false);
            return false;
        }
        AlertDialog dialog = Platform.getPlatform().getAlertDialog();
        dialog.showAlert(null, Locale.LOCALE.get("ActivationSucceededMajor"), Locale.LOCALE.get("ActivationSucceededMinor"), 1, Locale.LOCALE.get("OKButton"));
        return true;
    }

    private static boolean tryNow(ESDLicenseLibrary lib, ESDLicenseDialogs dialogs) {
        String key = dialogs.showTryNowDialog();
        if (key != null) {
            ESDLicenseLibrary.ESDError error = lib.tryNow(key);
            if (error == ESDLicenseLibrary.NO_ESD_ERROR) {
                return true;
            }
            dialogs.showErrorAlert(lib.getErrorMessage(error), false);
        }
        return false;
    }
}

