/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.license;

import com.lightcrafts.license.DummyLicenseLibrary;
import com.lightcrafts.license.ESDLicenseDialogs;
import com.lightcrafts.license.ESDLicenseLibrary;
import com.lightcrafts.license.ESDLicenseManager;
import com.lightcrafts.license.LicenseChecker;
import com.lightcrafts.license.LicenseCheckerModule;
import com.lightcrafts.license.Locale;
import com.lightcrafts.license.eSellerateLicenseDialogs;
import com.lightcrafts.license.eSellerateLicenseLibrary;
import com.lightcrafts.platform.Platform;
import java.util.Date;

class ESDLicenseCheckerModule
extends LicenseCheckerModule {
    static final Date trialLicenseRefDate = new Date();
    private static ESDLicenseLibrary m_lib;

    ESDLicenseCheckerModule() {
    }

    @Override
    public void run() {
        eSellerateLicenseDialogs dialogs = new eSellerateLicenseDialogs();
        ESDLicenseLibrary lib = ESDLicenseCheckerModule.getLicenseLibrary(dialogs);
        if (lib == null || !ESDLicenseManager.getLicense(lib, dialogs)) {
            System.exit(0);
        }
    }

    @Override
    String getLicenseKey() {
        return m_lib.getLicenseKey();
    }

    @Override
    String getMessage() {
        String key = this.getLicenseKey();
        return Locale.LOCALE.get("LicenseLabel") + ": " + (key != null && key.length() > 0 ? key : Locale.LOCALE.get("TrialLicenseSN"));
    }

    @Override
    boolean hasExpiredTrialLicense() {
        if (m_lib.getLicenseType() == ESDLicenseLibrary.LicenseType.LICENSE_NORMAL) {
            return false;
        }
        Date expirationDate = m_lib.getTrialLicenseExpirationDate();
        if (expirationDate == null) {
            return false;
        }
        return trialLicenseRefDate.after(expirationDate);
    }

    boolean relicense() {
        eSellerateLicenseDialogs dialogs = new eSellerateLicenseDialogs();
        ESDLicenseLibrary lib = ESDLicenseCheckerModule.getLicenseLibrary(dialogs);
        return lib != null && ESDLicenseManager.relicense(lib, dialogs);
    }

    boolean unlicense() {
        eSellerateLicenseDialogs dialogs = new eSellerateLicenseDialogs();
        ESDLicenseLibrary lib = ESDLicenseCheckerModule.getLicenseLibrary(dialogs);
        return lib != null && ESDLicenseManager.unlicense(lib, dialogs);
    }

    static synchronized ESDLicenseLibrary getLicenseLibrary(ESDLicenseDialogs dialogs) {
        if (m_lib == null) {
            m_lib = Platform.getType() != Platform.Linux ? new eSellerateLicenseLibrary() : new DummyLicenseLibrary();
            ESDLicenseLibrary.ESDError error = m_lib.initialize();
            if (error != ESDLicenseLibrary.NO_ESD_ERROR) {
                dialogs.showErrorAlert(m_lib.getErrorMessage(error), true);
                return null;
            }
            LicenseChecker.ensureDisposeOf(m_lib);
        }
        return m_lib;
    }
}

