/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.license;

import com.lightcrafts.license.ESDLicenseLibrary;
import com.lightcrafts.license.ESDLicenseManager;
import com.lightcrafts.license.eSellerateLicenseDialogs;
import com.lightcrafts.license.eSellerateLicenseLibrary;
import com.lightcrafts.utils.WebBrowser;
import java.awt.EventQueue;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;

public final class DummyLicenseLibrary
implements ESDLicenseLibrary {
    private static Preferences LicensePrefs = Preferences.userRoot().node("/com/lightcrafts/license");
    private static final String DummyLicenseKeyPrefsKey = "DummyLicenseKey";
    private static final String TrialLicenseStartPrefsKey = "TrialLicenseStart";
    private static final ResourceBundle Resources = ResourceBundle.getBundle("com.lightcrafts.license.resources.eSellerate");
    private static final String LICENSE_KEY_PATTERN_STRING = ".*\\s*\\w{10}(?:\\s*-\\s*[A-HJ-NP-TV-Y0-9]{4}){5}\\s*.*";
    private static final Pattern LICENSE_KEY_PATTERN = Pattern.compile(".*\\s*\\w{10}(?:\\s*-\\s*[A-HJ-NP-TV-Y0-9]{4}){5}\\s*.*", 34);

    @Override
    public ESDLicenseLibrary.ESDError activateKey(String key) {
        this.setLicenseKey(key);
        return NO_ESD_ERROR;
    }

    @Override
    public ESDLicenseLibrary.ESDError buyNow() {
        WebBrowser.browse(Resources.getString("BuyNowURL"));
        return NO_ESD_ERROR;
    }

    @Override
    public ESDLicenseLibrary.ESDError deactivateKey(String key) {
        LicensePrefs.remove(DummyLicenseKeyPrefsKey);
        return NO_ESD_ERROR;
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getErrorMessage(ESDLicenseLibrary.ESDError error) {
        return "Sorry, something's wrong with the licensing system.";
    }

    @Override
    public String getLicenseKey() {
        return LicensePrefs.get(DummyLicenseKeyPrefsKey, null);
    }

    public void setLicenseKey(String key) {
        LicensePrefs.put(DummyLicenseKeyPrefsKey, key);
    }

    public static Object getLicenseState() {
        String key = LicensePrefs.get(DummyLicenseKeyPrefsKey, null);
        if (key != null) {
            return key;
        }
        long start = LicensePrefs.getLong(TrialLicenseStartPrefsKey, 0L);
        if (start > 0L) {
            return start;
        }
        return null;
    }

    public static void setLicenseState(Object state) {
        LicensePrefs = Preferences.userRoot().node("/com/lightcrafts/license");
        if (state instanceof String) {
            LicensePrefs.put(DummyLicenseKeyPrefsKey, (String)state);
        } else if (state instanceof Long) {
            LicensePrefs.putLong(TrialLicenseStartPrefsKey, (Long)state);
        }
    }

    @Override
    public ESDLicenseLibrary.LicenseType getLicenseType() {
        if (this.getLicenseKey() != null) {
            return ESDLicenseLibrary.LicenseType.LICENSE_NORMAL;
        }
        if (this.getTrialLicenseExpirationDate() != null) {
            return ESDLicenseLibrary.LicenseType.LICENSE_TRIAL;
        }
        return ESDLicenseLibrary.LicenseType.LICENSE_INVALID;
    }

    public long getTrialLicenseStart() {
        return LicensePrefs.getLong(TrialLicenseStartPrefsKey, 0L);
    }

    public void setTrialLicenseStartDate() {
        LicensePrefs.putLong(TrialLicenseStartPrefsKey, System.currentTimeMillis());
    }

    @Override
    public Date getTrialLicenseExpirationDate() {
        long start = this.getTrialLicenseStart();
        if (start > 0L) {
            return new Date(start + 2592000000L);
        }
        return null;
    }

    @Override
    public Pattern getLicenseKeyPattern() {
        return LICENSE_KEY_PATTERN;
    }

    @Override
    public ESDLicenseLibrary.ESDError initialize() {
        return NO_ESD_ERROR;
    }

    @Override
    public boolean isBasicKey(String key) {
        return false;
    }

    @Override
    public boolean isKeyActivated(String key) {
        return false;
    }

    @Override
    public boolean isKeyValid(String key) {
        return LICENSE_KEY_PATTERN.matcher(key).matches();
    }

    @Override
    public boolean isInternetError(ESDLicenseLibrary.ESDError error) {
        return false;
    }

    @Override
    public ESDLicenseLibrary.ESDError manuallyActivateKey(String key) {
        this.setLicenseKey(key);
        return NO_ESD_ERROR;
    }

    @Override
    public ESDLicenseLibrary.ESDError probeLicenseType() {
        return NO_ESD_ERROR;
    }

    @Override
    public ESDLicenseLibrary.ESDError requestLicense() {
        return NO_ESD_ERROR;
    }

    @Override
    public boolean saveLicenseKey(String key) {
        return true;
    }

    @Override
    public ESDLicenseLibrary.ESDError tryNow(String key) {
        this.setTrialLicenseStartDate();
        return NO_ESD_ERROR;
    }

    public static void main(String[] args) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    eSellerateLicenseLibrary lib = new eSellerateLicenseLibrary();
                    eSellerateLicenseDialogs dialogs = new eSellerateLicenseDialogs();
                    if (ESDLicenseManager.getLicense(lib, dialogs)) {
                        // empty if block
                    }
                    lib.dispose();
                    System.exit(0);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

