/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.utils;

import com.lightcrafts.jai.utils.Job;
import com.lightcrafts.jai.utils.LCTileScheduler;
import com.lightcrafts.jai.utils.Request;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.TileComputationListener;
import com.lightcrafts.mediax.jai.TileRequest;
import java.awt.Point;
import java.awt.image.Raster;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class RequestJob
implements Job {
    final LCTileScheduler scheduler;
    final PlanarImage owner;
    final int tileX;
    final int tileY;
    final Raster[] tiles;
    final int offset;
    boolean done = false;
    Exception exception = null;

    RequestJob(LCTileScheduler scheduler, PlanarImage owner, int tileX, int tileY, Raster[] tiles, int offset) {
        this.scheduler = scheduler;
        this.owner = owner;
        this.tileX = tileX;
        this.tileY = tileY;
        this.tiles = tiles;
        this.offset = offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void compute() {
        block31: {
            List reqList;
            Map map = this.scheduler.tileRequests;
            synchronized (map) {
                Object tileID = LCTileScheduler.tileKey(this.owner, this.tileX, this.tileY);
                reqList = (List)this.scheduler.tileRequests.remove(tileID);
                this.scheduler.tileJobs.remove(tileID);
            }
            if (reqList != null && !reqList.isEmpty()) {
                int numReq;
                Point p = new Point(this.tileX, this.tileY);
                Integer tileStatus = new Integer(1);
                for (Request r : reqList) {
                    r.tileStatus.put(p, tileStatus);
                }
                try {
                    this.tiles[this.offset] = this.owner.getTile(this.tileX, this.tileY);
                    numReq = reqList.size();
                }
                catch (Exception e) {
                    this.exception = e;
                    int numReq2 = reqList.size();
                    Set listeners = LCTileScheduler.getListeners(reqList);
                    if (listeners == null || listeners.isEmpty()) break block31;
                    TileRequest[] requests = reqList.toArray(new TileRequest[0]);
                    tileStatus = new Integer(this.exception == null ? 2 : 4);
                    for (int i = 0; i < numReq2; ++i) {
                        ((Request)requests[i]).tileStatus.put(p, tileStatus);
                    }
                    Iterator iter = listeners.iterator();
                    if (this.exception == null) {
                        while (iter.hasNext()) {
                            TileComputationListener listener = (TileComputationListener)iter.next();
                            listener.tileComputed((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, this.tiles[this.offset]);
                        }
                    }
                    while (iter.hasNext()) {
                        TileComputationListener listener = (TileComputationListener)iter.next();
                        listener.tileComputationFailure((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, (Throwable)this.exception);
                    }
                }
                Set listeners = LCTileScheduler.getListeners(reqList);
                if (listeners != null && !listeners.isEmpty()) {
                    TileRequest[] requests = reqList.toArray(new TileRequest[0]);
                    tileStatus = new Integer(this.exception == null ? 2 : 4);
                    for (int i = 0; i < numReq; ++i) {
                        ((Request)requests[i]).tileStatus.put(p, tileStatus);
                    }
                    Iterator iter = listeners.iterator();
                    if (this.exception == null) {
                        while (iter.hasNext()) {
                            TileComputationListener listener = (TileComputationListener)iter.next();
                            listener.tileComputed((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, this.tiles[this.offset]);
                        }
                    } else {
                        while (iter.hasNext()) {
                            TileComputationListener listener = (TileComputationListener)iter.next();
                            listener.tileComputationFailure((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, (Throwable)this.exception);
                        }
                    }
                }
                break block31;
                break block31;
                catch (Error e) {
                    this.exception = new Exception(e);
                    int numReq3 = reqList.size();
                    listeners = LCTileScheduler.getListeners(reqList);
                    if (listeners == null || listeners.isEmpty()) break block31;
                    TileRequest[] requests = reqList.toArray(new TileRequest[0]);
                    tileStatus = new Integer(this.exception == null ? 2 : 4);
                    for (int i = 0; i < numReq3; ++i) {
                        ((Request)requests[i]).tileStatus.put(p, tileStatus);
                    }
                    Iterator iter = listeners.iterator();
                    if (this.exception == null) {
                        while (iter.hasNext()) {
                            TileComputationListener listener = (TileComputationListener)iter.next();
                            listener.tileComputed((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, this.tiles[this.offset]);
                        }
                    }
                    while (iter.hasNext()) {
                        TileComputationListener listener = (TileComputationListener)iter.next();
                        listener.tileComputationFailure((Object)this.scheduler, requests, this.owner, this.tileX, this.tileY, (Throwable)this.exception);
                    }
                    {
                        catch (Throwable throwable) {
                            int numReq4 = reqList.size();
                            Set listeners2 = LCTileScheduler.getListeners(reqList);
                            if (listeners2 != null && !listeners2.isEmpty()) {
                                TileRequest[] requests2 = reqList.toArray(new TileRequest[0]);
                                tileStatus = new Integer(this.exception == null ? 2 : 4);
                                for (int i = 0; i < numReq4; ++i) {
                                    ((Request)requests2[i]).tileStatus.put(p, tileStatus);
                                }
                                Iterator iter2 = listeners2.iterator();
                                if (this.exception == null) {
                                    while (iter2.hasNext()) {
                                        TileComputationListener listener = (TileComputationListener)iter2.next();
                                        listener.tileComputed((Object)this.scheduler, requests2, this.owner, this.tileX, this.tileY, this.tiles[this.offset]);
                                    }
                                } else {
                                    while (iter2.hasNext()) {
                                        TileComputationListener listener = (TileComputationListener)iter2.next();
                                        listener.tileComputationFailure((Object)this.scheduler, requests2, this.owner, this.tileX, this.tileY, (Throwable)this.exception);
                                    }
                                }
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
        this.done = true;
    }

    @Override
    public boolean notDone() {
        return !this.done;
    }

    @Override
    public PlanarImage getOwner() {
        return this.owner;
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public String toString() {
        String tString = "null";
        if (this.tiles[this.offset] != null) {
            tString = this.tiles[this.offset].toString();
        }
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": owner = " + this.owner.toString() + " tileX = " + Integer.toString(this.tileX) + " tileY = " + Integer.toString(this.tileY) + " tile = " + tString;
    }
}

