/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.utils;

import com.lightcrafts.mediax.jai.ImageFunction;

public class GaussianImageFunction
implements ImageFunction {
    final double s;

    public GaussianImageFunction(double s) {
        this.s = s;
    }

    static double gauss(double x, double y, double s) {
        return 1.0 / (s * s * 2.0 * Math.PI) * Math.exp(-(x * x + y * y) / (2.0 * s * s));
    }

    public void getElements(double startX, double startY, double deltaX, double deltaY, int countX, int countY, int element, double[] real, double[] imag) {
        for (int i = 0; i < countX; ++i) {
            double x = startX + deltaX * (double)i;
            for (int j = 0; j < countY; ++j) {
                double y = startY + deltaY * (double)j;
                real[i + countX * j] = (float)GaussianImageFunction.gauss(x, y, this.s);
            }
        }
    }

    public void getElements(float startX, float startY, float deltaX, float deltaY, int countX, int countY, int element, float[] real, float[] imag) {
        for (int i = 0; i < countX; ++i) {
            double x = startX + deltaX * (float)i;
            for (int j = 0; j < countY; ++j) {
                double y = startY + deltaY * (float)j;
                real[i + countX * j] = (float)GaussianImageFunction.gauss(x, y, this.s);
            }
        }
    }

    public int getNumElements() {
        return 1;
    }

    public boolean isComplex() {
        return false;
    }
}

