/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.jai.operator.LCMSColorConvertDescriptor;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.utils.LCMS;
import com.lightcrafts.utils.LCMS_ColorSpace;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.ShortInterleavedRaster;
import sun.awt.image.SunWritableRaster;

public class LCMSColorConvertOpImage
extends PointOpImage {
    final LCMSColorConvertDescriptor.RenderingIntent intent;
    final LCMSColorConvertDescriptor.RenderingIntent proofIntent;
    final ColorModel targetColorModel;
    final ICC_Profile proof;
    LCMS.Transform transform = null;
    final RenderedImage source;

    LCMSColorConvertOpImage(RenderedImage source, Map config, ImageLayout layout, ColorModel colorModel, LCMSColorConvertDescriptor.RenderingIntent intent, ICC_Profile proof, LCMSColorConvertDescriptor.RenderingIntent proofingIntent) {
        super(source, layout, config, true);
        this.source = source;
        this.targetColorModel = colorModel;
        this.proof = proof;
        this.intent = intent;
        this.proofIntent = proofingIntent;
        this.permitInPlaceOperation();
    }

    private static int mapLCMSType(int csType, int transferType) {
        if (transferType != 0 && transferType != 1) {
            throw new IllegalArgumentException("Unsupported Data Type: " + transferType);
        }
        switch (csType) {
            case 6: {
                return transferType == 0 ? LCMS.TYPE_GRAY_8 : LCMS.TYPE_GRAY_16;
            }
            case 5: {
                return transferType == 0 ? LCMS.TYPE_RGB_8 : LCMS.TYPE_RGB_16;
            }
            case 9: {
                return transferType == 0 ? LCMS.TYPE_CMYK_8 : LCMS.TYPE_CMYK_16;
            }
            case 1: {
                return transferType == 0 ? LCMS.TYPE_Lab_8 : LCMS.TYPE_Lab_16;
            }
        }
        throw new IllegalArgumentException("Unsupported Color Space Type: " + csType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        SunWritableRaster source;
        LCMSColorConvertOpImage lCMSColorConvertOpImage = this;
        synchronized (lCMSColorConvertOpImage) {
            if (this.transform == null) {
                int lcms_intent = this.intent.getValue() < 4 ? this.intent.getValue() : 1;
                int lcms_proofIntent = this.proofIntent.getValue() < 4 ? this.proofIntent.getValue() : 1;
                int lcms_flags = this.intent.getValue() == 4 || this.proofIntent.getValue() == 4 ? 8192 : 0;
                ColorSpace sourceCS = this.source.getColorModel().getColorSpace();
                LCMS.Profile sourceProfile = sourceCS instanceof LCMS_ColorSpace ? ((LCMS_ColorSpace)sourceCS).getProfile() : new LCMS.Profile(((ICC_ColorSpace)sourceCS).getProfile());
                ColorSpace targetCS = this.targetColorModel.getColorSpace();
                LCMS.Profile targetProfile = targetCS instanceof LCMS_ColorSpace ? ((LCMS_ColorSpace)targetCS).getProfile() : new LCMS.Profile(((ICC_ColorSpace)targetCS).getProfile());
                LCMS.Profile proofProfile = this.proof != null ? new LCMS.Profile(this.proof) : null;
                int inType = LCMSColorConvertOpImage.mapLCMSType(sourceCS.getType(), this.source.getColorModel().getTransferType());
                int outType = LCMSColorConvertOpImage.mapLCMSType(targetCS.getType(), this.colorModel.getTransferType());
                this.transform = proofProfile != null ? new LCMS.Transform(sourceProfile, inType, targetProfile, outType, proofProfile, lcms_proofIntent, lcms_intent, lcms_flags) : new LCMS.Transform(sourceProfile, inType, targetProfile, outType, lcms_intent, lcms_flags);
            }
        }
        if (sources[0] instanceof ByteInterleavedRaster && dest instanceof ByteInterleavedRaster) {
            source = (ByteInterleavedRaster)sources[0];
            ByteInterleavedRaster destination = (ByteInterleavedRaster)dest;
            this.transform.doTransform((ByteInterleavedRaster)source, destination);
        } else if (sources[0] instanceof ShortInterleavedRaster && dest instanceof ShortInterleavedRaster) {
            source = (ShortInterleavedRaster)sources[0];
            ShortInterleavedRaster destination = (ShortInterleavedRaster)dest;
            this.transform.doTransform((ShortInterleavedRaster)source, destination);
        } else {
            throw new IllegalArgumentException("Input and output rasters don't match!");
        }
    }
}

