/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.media.jai.util.ImageUtil;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import java.awt.Rectangle;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public class HDROpImage
extends PointOpImage {
    private static final int div = 2;
    private static final int c = 32768;
    private final double detail;
    private short[] intensityTable = new short[32769];
    private short[] gammaTable = new short[65536];
    private final double intensity;

    private double sigmoid(double x) {
        return x + this.intensity * x * (1.0 - 1.0 / (1.0 + Math.exp(-6.0 * (x - 0.01))));
    }

    public HDROpImage(RenderedImage source, RenderedImage mask, double intensity, double gamma, double detail, Map config) {
        super(source, mask, new ImageLayout(source), config, true);
        int i;
        int numBandsSrc = source.getSampleModel().getNumBands();
        int numBandsMask = mask.getSampleModel().getNumBands();
        int dataType = source.getSampleModel().getDataType();
        if (!(source.getSampleModel() instanceof PixelInterleavedSampleModel)) {
            throw new UnsupportedOperationException("Unsupported sample model: " + source.getSampleModel().getClass());
        }
        if (dataType != 1) {
            throw new UnsupportedOperationException("Unsupported data type: " + dataType);
        }
        if (numBandsSrc != 3) {
            throw new UnsupportedOperationException("Only three-banded sources are supported: " + numBandsSrc);
        }
        if (numBandsMask != 1) {
            throw new UnsupportedOperationException("Only single-banded masks are supported: " + numBandsMask);
        }
        this.permitInPlaceOperation();
        this.detail = detail;
        this.intensity = intensity;
        for (i = 0; i < 32769; ++i) {
            this.intensityTable[i] = (short)(32768.0 * this.sigmoid((double)i / 32768.0));
        }
        for (i = 0; i < this.gammaTable.length; ++i) {
            this.gammaTable[i] = (short)(65535.0 * Math.pow((double)i / 65535.0, gamma) + 0.5);
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor s1 = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor s2 = new RasterAccessor(sources[1], destRect, formatTags[1], this.getSourceImage(1).getColorModel());
        RasterAccessor d = new RasterAccessor((Raster)dest, destRect, formatTags[2], this.getColorModel());
        switch (d.getDataType()) {
            case 1: {
                this.computeRectUShort(s1, s2, d);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + d.getDataType());
            }
        }
        if (d.needsClamping()) {
            d.clampDataArrays();
        }
        d.copyDataToRaster();
    }

    private static int softLightBlendPixelsIntensity(int front, int back, short[] intensityTable) {
        int m = front * back / 32768;
        int s = 32768 - (32768 - front) * (32768 - back) / 32768;
        int p = 0xFFFF & intensityTable[back];
        return (32768 - p) * m / 32768 + p * s / 32768;
    }

    private static int softLightBlendPixels(int front, int back) {
        int m = front * back / 32768;
        int s = 32768 - (32768 - front) * (32768 - back) / 32768;
        return (32768 - back) * m / 32768 + back * s / 32768;
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor mask, RasterAccessor dst) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[] srcData = src.getShortDataArrays()[0];
        int srcROffset = srcBandOffsets[0];
        int srcGOffset = srcBandOffsets[1];
        int srcBOffset = srcBandOffsets[2];
        int maskLineStride = mask.getScanlineStride();
        int maskPixelStride = mask.getPixelStride();
        int[] maskBandOffsets = mask.getBandOffsets();
        short[] maskData = mask.getShortDataArrays()[0];
        int maskOffset = maskBandOffsets[0];
        int dstwidth = dst.getWidth();
        int dstheight = dst.getHeight();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[] dstData = dst.getShortDataArrays()[0];
        int dstROffset = dstBandOffsets[0];
        int dstGOffset = dstBandOffsets[1];
        int dstBOffset = dstBandOffsets[2];
        int overlays = (int)Math.floor(this.detail);
        int alpha = (int)(32768.0 * (this.detail - Math.floor(this.detail)));
        for (int row = 0; row < dstheight; ++row) {
            for (int col = 0; col < dstwidth; ++col) {
                int r = (0xFFFF & srcData[srcPixelStride * col + row * srcLineStride + srcROffset]) / 2;
                int g = (0xFFFF & srcData[srcPixelStride * col + row * srcLineStride + srcGOffset]) / 2;
                int b = (0xFFFF & srcData[srcPixelStride * col + row * srcLineStride + srcBOffset]) / 2;
                int m = 0xFFFF & maskData[maskPixelStride * col + row * maskLineStride + maskOffset];
                m = (0xFFFF & this.gammaTable[65535 - m]) / 2;
                for (int i = 0; i < overlays; ++i) {
                    m = HDROpImage.softLightBlendPixels(g, m);
                }
                if (alpha > 0) {
                    m = HDROpImage.softLightBlendPixels(g, m) * alpha / 32768 + m * (32768 - alpha) / 32768;
                }
                int rr = 2 * HDROpImage.softLightBlendPixelsIntensity(m, r, this.intensityTable);
                int gg = 2 * HDROpImage.softLightBlendPixelsIntensity(m, g, this.intensityTable);
                int bb = 2 * HDROpImage.softLightBlendPixelsIntensity(m, b, this.intensityTable);
                dstData[dstPixelStride * col + row * dstLineStride + dstROffset] = ImageUtil.clampUShort((int)rr);
                dstData[dstPixelStride * col + row * dstLineStride + dstGOffset] = ImageUtil.clampUShort((int)gg);
                dstData[dstPixelStride * col + row * dstLineStride + dstBOffset] = ImageUtil.clampUShort((int)bb);
            }
        }
    }
}

