/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadColorProfileException;
import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ColorProfileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.export.BitsPerChannelOption;
import com.lightcrafts.image.export.ImageExportOptionReader;
import com.lightcrafts.image.export.ImageExportOptionWriter;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.export.LZWCompressionOption;
import com.lightcrafts.image.export.MultilayerOption;
import com.lightcrafts.image.libs.LCImageLibException;
import com.lightcrafts.image.libs.LCTIFFReader;
import com.lightcrafts.image.libs.LCTIFFWriter;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import com.lightcrafts.image.metadata.XMPMetadataReader;
import com.lightcrafts.image.metadata.XMPMetadataWriter;
import com.lightcrafts.image.metadata.XMPUtil;
import com.lightcrafts.image.metadata.values.ByteMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.UndefinedMetaValue;
import com.lightcrafts.image.types.CanonTIFFRawImageProbe;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.MultipageTIFFImageType;
import com.lightcrafts.image.types.PhaseOneTIFFRawImageProbe;
import com.lightcrafts.image.types.SidecarTIFFImageType;
import com.lightcrafts.image.types.TrueImageTypeProvider;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.opimage.CachedImage;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.utils.ColorProfileInfo;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.bytebuffer.ByteBufferUtil;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.thread.ProgressThread;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XMLUtil;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Dimension;
import java.awt.color.ICC_Profile;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.w3c.dom.Document;

public class TIFFImageType
extends ImageType
implements TrueImageTypeProvider {
    public static final TIFFImageType INSTANCE = new TIFFImageType();
    private static final String[] EXTENSIONS = new String[]{"tif", "tiff"};
    private static final ArrayList<TrueImageTypeProvider> m_rawImageProbes = new ArrayList();

    @Override
    public boolean canExport() {
        return true;
    }

    @Override
    public Dimension getDimension(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        ImageMetadata metadata = imageInfo.getMetadata();
        ImageMetadataDirectory tiffDir = metadata.getDirectoryFor(TIFFDirectory.class);
        if (tiffDir == null) {
            return null;
        }
        ImageMetaValue width = tiffDir.getValue(256);
        ImageMetaValue height = tiffDir.getValue(257);
        return width != null && height != null ? new Dimension(width.getIntValue(), height.getIntValue()) : null;
    }

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public ICC_Profile getICCProfile(ImageInfo imageInfo) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException {
        ImageMetaValue v = imageInfo.getMetadata().getValue(TIFFDirectory.class, 34675);
        if (v != null) {
            byte[] iccData = ((UndefinedMetaValue)v).getUndefinedValue();
            try {
                return ICC_Profile.getInstance(iccData);
            }
            catch (IllegalArgumentException e) {
                throw new BadColorProfileException(imageInfo.getFile().getName());
            }
        }
        return null;
    }

    @Override
    public PlanarImage getImage(ImageInfo imageInfo, ProgressThread thread) throws BadImageFileException, UserCanceledException {
        return TIFFImageType.getImage(imageInfo, thread, false);
    }

    public static PlanarImage getImage(ImageInfo imageInfo, ProgressThread thread, boolean read2nd) throws BadImageFileException, UserCanceledException {
        try {
            String fileName = imageInfo.getFile().getAbsolutePath();
            LCTIFFReader reader = new LCTIFFReader(fileName, read2nd);
            PlanarImage image = reader.getImage(thread);
            assert (image instanceof CachedImage && image.getTileWidth() == 256 && image.getTileHeight() == 256);
            return image;
        }
        catch (LCImageLibException e) {
            throw new BadImageFileException(imageInfo.getFile(), (Throwable)e);
        }
    }

    public static RenderedImage getJPEGInterchangeImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        ImageMetadata metadata = imageInfo.getMetadata();
        ImageMetadataDirectory dir = metadata.getDirectoryFor(TIFFDirectory.class);
        if (dir == null) {
            return null;
        }
        return JPEGImageType.getImageFromBuffer(imageInfo.getByteBuffer(), dir.getValue(513), 0, dir.getValue(514), maxWidth, maxHeight);
    }

    @Override
    public String getName() {
        return "TIFF";
    }

    @Override
    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        return TIFFImageType.getPhotoshopThumbnail(imageInfo);
    }

    @Override
    public ImageType getTrueImageTypeOf(ImageInfo imageInfo) throws BadImageFileException, IOException {
        for (TrueImageTypeProvider p : m_rawImageProbes) {
            ImageType t = p.getTrueImageTypeOf(imageInfo);
            if (t == null) continue;
            return t;
        }
        try {
            Document lznDoc = TIFFImageType.getLZNDocumentImpl(imageInfo);
            if (lznDoc != null) {
                XmlDocument xmlDoc = new XmlDocument(lznDoc.getDocumentElement());
                XmlNode root = xmlDoc.getRoot();
                XmlNode imageNode = root.getChild("Image");
                if (imageNode.hasAttribute("self")) {
                    return MultipageTIFFImageType.INSTANCE;
                }
                return SidecarTIFFImageType.INSTANCE;
            }
        }
        catch (UnknownImageTypeException unknownImageTypeException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Document getXMP(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        return TIFFImageType.getXMP(imageInfo, TIFFDirectory.class);
    }

    @Override
    public ExportOptions newExportOptions() {
        return new ExportOptions();
    }

    @Override
    public void putImage(ImageInfo imageInfo, PlanarImage image, ImageExportOptions options, Document lznDoc, ProgressThread thread) throws IOException {
        ImageMetadata metadata;
        ExportOptions tiffOptions = (ExportOptions)options;
        File exportFile = options.getExportFile();
        File tempFile = null;
        try {
            metadata = imageInfo.getMetadata();
        }
        catch (BadImageFileException e) {
            metadata = new ImageMetadata(this);
        }
        catch (UnknownImageTypeException e) {
            metadata = new ImageMetadata(this);
        }
        try {
            LCTIFFWriter writer;
            if (tiffOptions.multilayer.getValue()) {
                File originalFile = imageInfo.getFile();
                if (exportFile.equals(originalFile)) {
                    tempFile = File.createTempFile("LightZone", "tif");
                    FileUtil.copyFile(originalFile, tempFile);
                    originalFile = tempFile;
                }
                writer = new LCTIFFWriter(exportFile.getAbsolutePath(), originalFile.getAbsolutePath(), tiffOptions.resizeWidth.getValue(), tiffOptions.resizeHeight.getValue(), tiffOptions.resolution.getValue(), tiffOptions.resolutionUnit.getValue());
            } else {
                writer = new LCTIFFWriter(options.getExportFile().getAbsolutePath(), tiffOptions.resizeWidth.getValue(), tiffOptions.resizeHeight.getValue(), tiffOptions.resolution.getValue(), tiffOptions.resolutionUnit.getValue());
            }
            writer.setIntField(259, tiffOptions.lzwCompression.getValue() ? 5 : 1);
            ICC_Profile profile = ColorProfileInfo.getExportICCProfileFor(tiffOptions.colorProfile.getValue());
            if (profile == null) {
                profile = JAIContext.sRGBExportColorProfile;
            }
            writer.setICCProfile(profile);
            if (lznDoc != null) {
                byte[] buf = XMLUtil.encodeDocument(lznDoc, false);
                writer.setByteField(50919, buf);
            }
            writer.putMetadata(metadata);
            writer.putImageStriped((RenderedImage)image, thread);
            writer.dispose();
        }
        catch (LCImageLibException e) {
            IOException ioe = new IOException("TIFF export failed");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        TIFFMetadataReader reader = new TIFFMetadataReader(imageInfo);
        ImageMetadata metadata = reader.readMetadata();
        Document xmpDoc = this.getXMP(imageInfo);
        if (xmpDoc != null) {
            ImageMetadata xmpMetadata = XMPMetadataReader.readFrom(xmpDoc);
            metadata.mergeFrom(xmpMetadata);
        }
    }

    @Override
    public void writeMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        File xmpFile = new File(imageInfo.getXMPFilename());
        ImageMetadata metadata = imageInfo.getCurrentMetadata();
        XMPMetadataWriter.mergeInto(metadata, xmpFile);
        metadata.clearEdited();
    }

    static Document getXMP(ImageInfo imageInfo, Class<? extends ImageMetadataDirectory> dirClass) throws BadImageFileException, IOException, UnknownImageTypeException {
        ImageMetadata metadata = imageInfo.getMetadata();
        ImageMetaValue xmpValue = metadata.getValue(dirClass, 700);
        if (xmpValue == null) {
            return null;
        }
        byte[] xmpBytes = XMPUtil.getXMPDataFrom(xmpValue);
        if (xmpBytes == null) {
            return null;
        }
        return XMLUtil.readDocumentFrom(new ByteArrayInputStream(xmpBytes));
    }

    protected TIFFImageType() {
    }

    protected static Document getLZNDocumentImpl(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        ByteArrayInputStream in;
        Document xmpDoc;
        Document lznDoc;
        ImageMetadata metadata = imageInfo.getMetadata();
        ImageMetaValue lznValue = metadata.getValue(TIFFDirectory.class, 50919);
        if (lznValue != null) {
            byte[] buf = ((ByteMetaValue)lznValue).getByteValues();
            ByteArrayInputStream in2 = new ByteArrayInputStream(buf);
            return XMLUtil.readDocumentFrom(in2);
        }
        ImageMetaValue xmpValue = metadata.getValue(TIFFDirectory.class, 700);
        byte[] xmp = XMPUtil.getXMPDataFrom(xmpValue);
        if (xmp != null && (lznDoc = XMPUtil.getLZNDocumentFrom(xmpDoc = XMLUtil.readDocumentFrom(in = new ByteArrayInputStream(xmp)))) != null) {
            return lznDoc;
        }
        return null;
    }

    private static RenderedImage getPhotoshopThumbnail(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        int blockSize;
        ImageMetadata metadata = imageInfo.getMetadata();
        ImageMetaValue photoshop = metadata.getValue(TIFFDirectory.class, 34377);
        if (photoshop == null) {
            return null;
        }
        byte[] bytes = ((ByteMetaValue)photoshop).getByteValues();
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        try {
            while (true) {
                String blockSig;
                if (!(blockSig = ByteBufferUtil.getString(buf, 4, "ASCII")).equals("8BIM")) {
                    return null;
                }
                int blockID = ByteBufferUtil.getUnsignedShort(buf);
                int blockNameLen = ByteBufferUtil.getUnsignedByte(buf);
                ByteBufferUtil.skipBytes(buf, blockNameLen);
                if ((blockNameLen + 1) % 2 == 1) {
                    ByteBufferUtil.skipBytes(buf, 1);
                }
                blockSize = buf.getInt();
                if (blockID != 1036) {
                    if (blockSize % 2 == 1) {
                        ++blockSize;
                    }
                    ByteBufferUtil.skipBytes(buf, blockSize);
                    continue;
                }
                break;
            }
        }
        catch (BufferUnderflowException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if ((buf = ByteBuffer.wrap(bytes, buf.position(), blockSize)).getInt() != 1) {
            return null;
        }
        buf.getInt();
        buf.getInt();
        buf.getInt();
        buf.getInt();
        int jpegSize = buf.getInt();
        buf.getShort();
        buf.getShort();
        return JPEGImageType.getImageFromBuffer(bytes, buf.position(), jpegSize, null, 0, 0);
    }

    static {
        m_rawImageProbes.add(CanonTIFFRawImageProbe.INSTANCE);
        m_rawImageProbes.add(PhaseOneTIFFRawImageProbe.INSTANCE);
    }

    public static class ExportOptions
    extends ImageFileExportOptions {
        public final BitsPerChannelOption bitsPerChannel = new BitsPerChannelOption(8, (ImageExportOptions)this);
        public final LZWCompressionOption lzwCompression = new LZWCompressionOption(false, (ImageExportOptions)this);
        public final MultilayerOption multilayer = new MultilayerOption(false, (ImageExportOptions)this);

        public ExportOptions() {
            this(INSTANCE);
        }

        @Override
        public void readFrom(ImageExportOptionReader r) throws IOException {
            super.readFrom(r);
            this.bitsPerChannel.readFrom(r);
            this.lzwCompression.readFrom(r);
            this.multilayer.readFrom(r);
        }

        @Override
        public void writeTo(ImageExportOptionWriter w) throws IOException {
            super.writeTo(w);
            this.bitsPerChannel.writeTo(w);
            this.lzwCompression.writeTo(w);
            this.multilayer.writeTo(w);
        }

        protected ExportOptions(ImageType instance) {
            super(instance);
        }

        @Override
        protected void save(XmlNode node) {
            super.save(node);
            this.bitsPerChannel.save(node);
            this.lzwCompression.save(node);
            this.multilayer.save(node);
        }

        @Override
        protected void restore(XmlNode node) throws XMLException {
            super.restore(node);
            this.bitsPerChannel.restore(node);
            this.lzwCompression.restore(node);
            if (node.hasChild(this.multilayer.getName())) {
                this.multilayer.restore(node);
            }
        }
    }
}

