/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.LZNDocumentProvider;
import com.lightcrafts.utils.xml.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.w3c.dom.Document;

public final class SidecarJPEGImageType
extends JPEGImageType
implements LZNDocumentProvider {
    public static final SidecarJPEGImageType INSTANCE = new SidecarJPEGImageType();

    @Override
    public Document getLZNDocument(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        ByteBuffer buf = SidecarJPEGImageType.getFirstSegment(imageInfo, (byte)-28);
        if (buf != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(buf.array());
            return XMLUtil.readDocumentFrom(is);
        }
        return null;
    }

    @Override
    public String getName() {
        return super.getName() + "-LZN";
    }

    @Override
    public ExportOptions newExportOptions() {
        return new ExportOptions();
    }

    private SidecarJPEGImageType() {
    }

    public static final class ExportOptions
    extends JPEGImageType.ExportOptions {
        ExportOptions() {
            super(INSTANCE);
        }
    }
}

