/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.MRWMetadataReader;
import com.lightcrafts.image.types.MRWImageInfo;
import com.lightcrafts.image.types.RawImageType;
import java.awt.image.RenderedImage;
import java.io.IOException;

public final class MRWImageType
extends RawImageType {
    public static final MRWImageType INSTANCE = new MRWImageType();
    private static final String[] EXTENSIONS = new String[]{"mrw"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "MRW";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        return super.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public boolean hasFastPreview() {
        return true;
    }

    @Override
    public MRWImageInfo newAuxiliaryInfo(ImageInfo imageInfo) {
        return new MRWImageInfo(imageInfo);
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        MRWMetadataReader reader = new MRWMetadataReader(imageInfo);
        reader.readMetadata();
        MRWImageInfo info = (MRWImageInfo)imageInfo.getAuxiliaryInfo();
        info.setTIFFBlock(reader.getTIFFBlock());
    }

    private MRWImageType() {
    }
}

