/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.image.types.TIFFImageType;
import java.awt.image.RenderedImage;
import java.io.IOException;

public final class KDCImageType
extends RawImageType {
    public static final KDCImageType INSTANCE = new KDCImageType();
    private static final String[] EXTENSIONS = new String[]{"kdc"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "KDC";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        RenderedImage image = TIFFImageType.getJPEGInterchangeImage(imageInfo, maxWidth, maxHeight);
        return image != null ? image : super.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public boolean hasFastPreview() {
        return true;
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException {
        TIFFMetadataReader reader = new TIFFMetadataReader(imageInfo);
        MetadataUtil.removePreviewMetadataFrom(reader.readMetadata());
    }

    private KDCImageType() {
    }
}

