/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.CIFFDirectory;
import com.lightcrafts.image.metadata.CIFFMetadataReader;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.jai.JAIContext;
import java.awt.color.ColorSpace;
import java.awt.image.RenderedImage;
import java.io.IOException;

public final class CIFFImageType
extends RawImageType {
    public static final CIFFImageType INSTANCE = new CIFFImageType();
    private static final String[] EXTENSIONS = new String[]{"crw"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "CIFF";
    }

    @Override
    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        return this.getPreviewImage(imageInfo, 640, 480);
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        ImageMetadata metadata = imageInfo.getMetadata();
        ImageMetadataDirectory dir = metadata.getDirectoryFor(CIFFDirectory.class);
        if (dir != null) {
            RenderedImage image;
            ImageMetaValue colorSpace = dir.getValue(4276);
            ColorSpace cs = JAIContext.sRGBColorSpace;
            if (colorSpace != null) {
                switch (colorSpace.getIntValue()) {
                    case 2: {
                        cs = JAIContext.adobeRGBColorSpace;
                    }
                }
            }
            if ((image = JPEGImageType.getImageFromBuffer(imageInfo.getByteBuffer(), dir.getValue(0x200702), 0, dir.getValue(2098945), cs, maxWidth, maxHeight)) != null) {
                return image;
            }
        }
        return super.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public boolean hasFastPreview() {
        return true;
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException {
        new CIFFMetadataReader(imageInfo).readMetadata();
    }

    private CIFFImageType() {
    }
}

