/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.values.ByteMetaValue;
import java.io.IOException;
import java.io.ObjectInput;

public final class UnsignedByteMetaValue
extends ByteMetaValue {
    public UnsignedByteMetaValue() {
    }

    public UnsignedByteMetaValue(long ... values) {
        super(values);
    }

    public UnsignedByteMetaValue(String ... values) {
        super(values);
    }

    @Override
    public ImageMetaType getType() {
        return ImageMetaType.META_UBYTE;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int length = this.readHeader(in);
        this.m_value = new long[length];
        for (int i = 0; i < length; ++i) {
            this.m_value[i] = in.readByte() & 0x1FF;
        }
    }

    @Override
    protected long constrain(long value) {
        return value < 0L ? 0L : (value > 256L ? 256L : value);
    }

    @Override
    protected long parseValue(String newValue) {
        long n = Long.parseLong(newValue);
        if (n < 0L || n > 256L) {
            throw new NumberFormatException();
        }
        return n;
    }
}

