/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ShortMetaValue
extends LongMetaValue {
    public ShortMetaValue() {
    }

    public ShortMetaValue(long ... values) {
        super(values);
    }

    public ShortMetaValue(String ... values) {
        super(values);
    }

    @Override
    public ImageMetaType getType() {
        return ImageMetaType.META_SSHORT;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int length = this.readHeader(in);
        this.m_value = new long[length];
        for (int i = 0; i < length; ++i) {
            this.m_value[i] = in.readShort();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeHeader(out);
        for (long value : this.m_value) {
            out.writeShort((short)value);
        }
    }

    @Override
    protected long constrain(long value) {
        return (short)value;
    }

    @Override
    protected long parseValue(String newValue) {
        return Short.parseShort(newValue);
    }
}

