/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.values.NumericMetaValue;
import com.lightcrafts.utils.LCArrays;
import com.lightcrafts.utils.Rational;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LongMetaValue
extends NumericMetaValue {
    protected long[] m_value;

    public LongMetaValue() {
    }

    public LongMetaValue(long ... values) {
        this.m_value = this.constrain(values);
    }

    public LongMetaValue(String ... values) {
        this.setValuesImpl(values);
    }

    @Override
    public final LongMetaValue clone() {
        LongMetaValue copy = (LongMetaValue)super.clone();
        copy.m_value = (long[])this.m_value.clone();
        return copy;
    }

    @Override
    public final int compareTo(Object o) {
        if (o instanceof NumericMetaValue) {
            NumericMetaValue rightValue = (NumericMetaValue)o;
            long leftLong = this.getLongValue();
            long rightLong = rightValue.getLongValue();
            return (int)(leftLong - rightLong);
        }
        return super.compareTo(o);
    }

    @Override
    public final int compareTo(String s) {
        try {
            long rightLong = s.indexOf(47) > 0 ? Rational.parseRational(s).longValue() : Long.parseLong(s);
            long leftLong = this.getLongValue();
            return (int)(leftLong - rightLong);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @Override
    public final long getLongValue() {
        return this.getLongValueAt(0);
    }

    public final long getLongValueAt(int index) {
        return this.m_value[index];
    }

    public final long[] getLongValues() {
        return this.m_value;
    }

    @Override
    public ImageMetaType getType() {
        return ImageMetaType.META_SLONG;
    }

    @Override
    public final int getValueCount() {
        return this.m_value != null ? this.m_value.length : 0;
    }

    @Override
    public final boolean isLegalValue(String value) {
        try {
            this.parseValue(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public final void setLongValue(long newValue) {
        this.setLongValueAt(newValue, 0);
    }

    public final synchronized void setLongValueAt(long newValue, int index) {
        this.checkIsEditable();
        if (this.m_value == null) {
            this.m_value = new long[index + 1];
        } else if (index >= this.m_value.length) {
            this.m_value = (long[])LCArrays.resize(this.m_value, index + 1);
        }
        this.m_value[index] = this.constrain(newValue);
        this.dirty();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int length = this.readHeader(in);
        this.m_value = new long[length];
        for (int i = 0; i < length; ++i) {
            this.m_value[i] = in.readLong();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeHeader(out);
        for (long value : this.m_value) {
            out.writeLong(value);
        }
    }

    @Override
    protected final void appendValueImpl(String newValue) {
        long newLong = this.parseValue(newValue);
        if (this.m_value == null) {
            this.m_value = new long[]{newLong};
        } else {
            this.m_value = (long[])LCArrays.resize(this.m_value, this.m_value.length + 1);
            this.m_value[this.m_value.length - 1] = newLong;
        }
    }

    protected long constrain(long value) {
        return value;
    }

    @Override
    protected final String[] getValuesImpl() {
        if (this.m_value == null) {
            return null;
        }
        String[] value = new String[this.m_value.length];
        for (int i = 0; i < this.m_value.length; ++i) {
            value[i] = Long.toString(this.getLongValueAt(i));
        }
        return value;
    }

    protected long parseValue(String newValue) {
        return Long.parseLong(newValue);
    }

    @Override
    protected final void setValuesImpl(String[] newValue) {
        if (this.m_value == null || this.m_value.length != newValue.length) {
            this.m_value = new long[newValue.length];
        }
        for (int i = 0; i < newValue.length; ++i) {
            this.m_value[i] = this.parseValue(newValue[i]);
        }
    }

    @Override
    protected final String toStringImpl() {
        if (this.m_value == null) {
            return null;
        }
        ImageMetadataDirectory owningDir = this.getOwningDirectory();
        int tagID = this.getOwningTagID();
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        for (long value : this.m_value) {
            if (!comma) {
                comma = true;
            } else {
                sb.append(',');
            }
            String valueAsString = owningDir != null ? owningDir.getTagValueLabelFor(tagID, value) : Long.toString(value);
            sb.append(valueAsString);
        }
        return sb.toString();
    }

    private long[] constrain(long[] values) {
        long[] newValues = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = this.constrain(values[i]);
        }
        return newValues;
    }
}

