/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.XMPConstants;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.utils.LCArrays;
import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.xml.XMLUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DateMetaValue
extends ImageMetaValue {
    private static final SimpleDateFormat m_canonicalDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    private static final SimpleDateFormat[] m_dateFormats = new SimpleDateFormat[]{XMPConstants.ISO_8601_DATE_FORMAT, m_canonicalDateFormat, new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"), new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("dd-MMM-yyyy"), new SimpleDateFormat("dd/MMM/yyyy"), new SimpleDateFormat("MMM dd, yyyy")};
    private Date[] m_value;

    public DateMetaValue() {
    }

    public DateMetaValue(Date ... values) {
        this.m_value = values;
    }

    public DateMetaValue(long value) {
        this(new Date(value));
    }

    public DateMetaValue(String ... values) {
        this.setValuesImpl(values);
    }

    @Override
    public DateMetaValue clone() {
        DateMetaValue copy = (DateMetaValue)super.clone();
        copy.m_value = (Date[])this.m_value.clone();
        return copy;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof DateMetaValue) {
            DateMetaValue rightVal = (DateMetaValue)o;
            Date leftDate = this.getDateValue();
            Date rightDate = rightVal.getDateValue();
            return leftDate.compareTo(rightDate);
        }
        return super.compareTo(o);
    }

    public Date getDateValue() {
        return this.m_value[0];
    }

    public Date[] getDateValues() {
        return this.m_value;
    }

    @Override
    public long getLongValue() {
        return this.getDateValue().getTime();
    }

    @Override
    public ImageMetaType getType() {
        return ImageMetaType.META_DATE;
    }

    @Override
    public int getValueCount() {
        return this.m_value != null ? this.m_value.length : 0;
    }

    @Override
    public boolean isLegalValue(String value) {
        try {
            DateMetaValue.parseValue(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public synchronized void setDateValueAt(Date newValue, int index) {
        this.checkIsEditable();
        if (this.m_value == null) {
            this.m_value = new Date[index + 1];
        } else if (index >= this.m_value.length) {
            this.m_value = (Date[])LCArrays.resize(this.m_value, index + 1);
        }
        this.m_value[index] = newValue;
        this.dirty();
    }

    @Override
    public void setLongValue(long newValue) {
        this.setDateValueAt(new Date(newValue), 0);
    }

    @Override
    public Element toXMP(Document xmpDoc, String nsURI, String prefix) {
        String tagName = this.getTagName();
        if (tagName == null) {
            return null;
        }
        Element tagElement = xmpDoc.createElementNS(nsURI, prefix + ':' + tagName);
        Date[] values = this.getDateValues();
        if (values.length == 1) {
            XMLUtil.setTextContentOf(tagElement, TextUtil.dateFormat(XMPConstants.ISO_8601_DATE_FORMAT, this.m_value[0]));
        } else {
            Element seqElement = XMLUtil.addElementChildTo(tagElement, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Seq");
            for (Date value : values) {
                Element listItem = XMLUtil.addElementChildTo(seqElement, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:li");
                XMLUtil.setTextContentOf(listItem, TextUtil.dateFormat(XMPConstants.ISO_8601_DATE_FORMAT, value));
            }
        }
        return tagElement;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int length = this.readHeader(in);
        this.m_value = new Date[length];
        for (int i = 0; i < length; ++i) {
            this.m_value[i] = new Date(in.readLong());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeHeader(out);
        for (Date value : this.m_value) {
            out.writeLong(value.getTime());
        }
    }

    @Override
    protected void appendValueImpl(String newValue) {
        Date newDate = DateMetaValue.parseValue(newValue);
        if (this.m_value == null) {
            this.m_value = new Date[]{newDate};
        } else {
            this.m_value = (Date[])LCArrays.resize(this.m_value, this.m_value.length + 1);
            this.m_value[this.m_value.length - 1] = newDate;
        }
    }

    @Override
    protected String[] getValuesImpl() {
        if (this.m_value == null) {
            return null;
        }
        String[] value = new String[this.m_value.length];
        for (int i = 0; i < this.m_value.length; ++i) {
            value[i] = TextUtil.dateFormat(m_canonicalDateFormat, this.m_value[i]);
        }
        return value;
    }

    @Override
    protected void setValuesImpl(String[] newValue) {
        if (this.m_value == null || this.m_value.length != newValue.length) {
            this.m_value = new Date[newValue.length];
        }
        for (int i = 0; i < newValue.length; ++i) {
            this.m_value[i] = DateMetaValue.parseValue(newValue[i]);
        }
    }

    @Override
    protected String toStringImpl() {
        if (this.m_value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        for (Date value : this.m_value) {
            if (!comma) {
                comma = true;
            } else {
                sb.append(',');
            }
            sb.append(TextUtil.dateFormat(m_canonicalDateFormat, value).trim());
        }
        return sb.toString();
    }

    private static Date parseValue(String value) {
        for (SimpleDateFormat format : m_dateFormats) {
            try {
                return format.parse(value);
            }
            catch (ParseException e) {
            }
        }
        throw new IllegalArgumentException();
    }
}

