/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.makernotes;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.image.metadata.makernotes.PentaxTags;
import com.lightcrafts.image.metadata.providers.ApertureProvider;
import com.lightcrafts.image.metadata.providers.CaptureDateTimeProvider;
import com.lightcrafts.image.metadata.providers.FocalLengthProvider;
import com.lightcrafts.image.metadata.providers.ISOProvider;
import com.lightcrafts.image.metadata.providers.LensProvider;
import com.lightcrafts.image.metadata.providers.PreviewImageProvider;
import com.lightcrafts.image.metadata.providers.ShutterSpeedProvider;
import com.lightcrafts.image.metadata.providers.WidthHeightProvider;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.UndefinedMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.image.types.PEFImageType;
import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public final class PentaxDirectory
extends MakerNotesDirectory
implements ApertureProvider,
CaptureDateTimeProvider,
FocalLengthProvider,
ISOProvider,
LensProvider,
PreviewImageProvider,
ShutterSpeedProvider,
WidthHeightProvider {
    private static final Pattern m_focalLengthPattern = Pattern.compile(".*(?:\\*IST D|K10D|OPTIO [A-Z]).*");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.makernotes.PentaxTags");

    @Override
    public float getAperture() {
        ImageMetaValue value = this.getValue(19);
        return value == null ? 0.0f : MetadataUtil.fixFStop((float)value.getIntValue() / 10.0f);
    }

    @Override
    public Date getCaptureDateTime() {
        ImageMetaValue value = this.getValue(6);
        return value instanceof DateMetaValue ? ((DateMetaValue)value).getDateValue() : null;
    }

    @Override
    public float getFocalLength() {
        ImageMetaValue value = this.getValue(29);
        if (value == null) {
            return 0.0f;
        }
        String make = this.getOwningMetadata().getCameraMake(true);
        if (m_focalLengthPattern.matcher(make).matches()) {
            return (float)value.getIntValue() / 100.0f;
        }
        return (float)value.getIntValue() / 10.0f;
    }

    @Override
    public int getImageHeight() {
        ImageMetaValue value = this.getValue(57);
        if (value != null && value.getValueCount() == 2) {
            try {
                return Integer.parseInt(value.getValues()[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public int getImageWidth() {
        ImageMetaValue value = this.getValue(57);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int getISO() {
        String label = this.hasTagValueLabelFor(20);
        if (label != null) {
            try {
                return Integer.parseInt(label);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public String getLens() {
        return this.hasTagValueLabelFor(63);
    }

    @Override
    public int[] getMakerNotesAdjustments(LCByteBuffer buf, int offset) {
        return new int[]{6, offset};
    }

    @Override
    public String getName() {
        return "Pentax";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        return PEFImageType.INSTANCE.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public float getShutterSpeed() {
        ImageMetaValue value = this.getValue(18);
        return value != null ? value.getFloatValue() * 1.0E-5f : 0.0f;
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public void putValue(Integer tagID, ImageMetaValue value) {
        switch (tagID) {
            case 31: 
            case 32: 
            case 33: {
                if (value.getValueCount() <= 1) break;
                value = new UnsignedShortMetaValue(value.getIntValue());
                break;
            }
            case 6: {
                if (!(value instanceof UndefinedMetaValue) || value.getValueCount() != 4) {
                    return;
                }
                byte[] buf = ((UndefinedMetaValue)value).getUndefinedValue();
                GregorianCalendar cal = new GregorianCalendar((buf[0] & 0xFF) << 8 | buf[1] & 0xFF, buf[2] - 1, buf[3]);
                value = new DateMetaValue(cal.getTime());
                break;
            }
            case 7: {
                if (!(value instanceof UndefinedMetaValue) || value.getValueCount() < 3) {
                    return;
                }
                ImageMetaValue dateValue = this.getValue(6);
                Date date = ((DateMetaValue)dateValue).getDateValue();
                byte[] buf = ((UndefinedMetaValue)value).getUndefinedValue();
                date.setTime(date.getTime() + (long)((buf[0] * 60 * 60 + buf[1] * 60 + buf[2]) * 1000));
                return;
            }
            case 9: {
                if (value.getValueCount() != 2) break;
                String[] values = value.getValues();
                try {
                    int v0 = Integer.parseInt(values[0]);
                    int v1 = Integer.parseInt(values[1]);
                    value = new UnsignedShortMetaValue(v0 << 8 | v1);
                    break;
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            case 63: {
                if (value.getValueCount() != 2) {
                    return;
                }
                String[] values = value.getValues();
                try {
                    int lensGroupID = Integer.parseInt(values[0]);
                    int lensID = Integer.parseInt(values[1]);
                    int lensLabelID = lensGroupID << 8 | lensID;
                    value = new UnsignedShortMetaValue(lensLabelID);
                    break;
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
        }
        super.putValue(tagID, value);
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        switch (value.getOwningTagID()) {
            case 27: 
            case 28: {
                return TextUtil.tenths((float)value.getIntValue() / 256.0f);
            }
            case 22: {
                return TextUtil.tenths((float)(value.getIntValue() - 50) / 10.0f);
            }
            case 18: {
                return MetadataUtil.shutterSpeedString(this.getShutterSpeed());
            }
            case 19: {
                return TextUtil.tenths(this.getAperture());
            }
            case 29: {
                return TextUtil.tenths(this.getFocalLength()) + "mm";
            }
            case 2: 
            case 57: {
                String[] values = value.getValues();
                if (values.length != 2) break;
                return values[0] + " x " + values[1];
            }
            case 63: {
                return this.getLens();
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return PentaxTags.class;
    }

    private static void add(int id, String name, ImageMetaType type) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, false);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    static {
        PentaxDirectory.add(15, "AutoAFPoint", ImageMetaType.META_USHORT);
        PentaxDirectory.add(512, "BlackPoint", ImageMetaType.META_USHORT);
        PentaxDirectory.add(27, "BlueBalance", ImageMetaType.META_USHORT);
        PentaxDirectory.add(32, "Contrast", ImageMetaType.META_USHORT);
        PentaxDirectory.add(1022, "DataDump", ImageMetaType.META_UNDEFINED);
        PentaxDirectory.add(6, "Date", ImageMetaType.META_DATE);
        PentaxDirectory.add(36, "DestinationCity", ImageMetaType.META_USHORT);
        PentaxDirectory.add(4097, "DestinationCityCode", ImageMetaType.META_UNDEFINED);
        PentaxDirectory.add(38, "DestinationDST", ImageMetaType.META_USHORT);
        PentaxDirectory.add(30, "DigitalZoom", ImageMetaType.META_USHORT);
        PentaxDirectory.add(22, "ExposureCompensation", ImageMetaType.META_USHORT);
        PentaxDirectory.add(18, "ExposureTime", ImageMetaType.META_USHORT);
        PentaxDirectory.add(12, "FlashMode", ImageMetaType.META_USHORT);
        PentaxDirectory.add(19, "FNumber", ImageMetaType.META_USHORT);
        PentaxDirectory.add(29, "FocalLength", ImageMetaType.META_USHORT);
        PentaxDirectory.add(16, "FocusPosition", ImageMetaType.META_USHORT);
        PentaxDirectory.add(41, "FrameNumber", ImageMetaType.META_USHORT);
        PentaxDirectory.add(35, "HomeTownCity", ImageMetaType.META_USHORT);
        PentaxDirectory.add(4096, "HomeTownCityCode", ImageMetaType.META_UNDEFINED);
        PentaxDirectory.add(37, "HomeTownDST", ImageMetaType.META_USHORT);
        PentaxDirectory.add(9, "ImageSize", ImageMetaType.META_USHORT);
        PentaxDirectory.add(20, "ISO", ImageMetaType.META_USHORT);
        PentaxDirectory.add(63, "LensType", ImageMetaType.META_UBYTE);
        PentaxDirectory.add(23, "MeteringMode", ImageMetaType.META_USHORT);
        PentaxDirectory.add(1, "Mode", ImageMetaType.META_USHORT);
        PentaxDirectory.add(11, "PictureMode", ImageMetaType.META_USHORT);
        PentaxDirectory.add(8192, "PreviewImageData", ImageMetaType.META_UNDEFINED);
        PentaxDirectory.add(3, "PreviewImageLength", ImageMetaType.META_ULONG);
        PentaxDirectory.add(2, "PreviewImageSize", ImageMetaType.META_USHORT);
        PentaxDirectory.add(4, "PreviewImageStart", ImageMetaType.META_ULONG);
        PentaxDirectory.add(3584, "PrintImageMatching", ImageMetaType.META_UNDEFINED);
        PentaxDirectory.add(8, "Quality", ImageMetaType.META_USHORT);
        PentaxDirectory.add(57, "RawImageSize", ImageMetaType.META_USHORT);
        PentaxDirectory.add(28, "RedBalance", ImageMetaType.META_USHORT);
        PentaxDirectory.add(31, "Saturation", ImageMetaType.META_USHORT);
        PentaxDirectory.add(33, "Sharpness", ImageMetaType.META_USHORT);
        PentaxDirectory.add(7, "Time", ImageMetaType.META_UNDEFINED);
        PentaxDirectory.add(1026, "ToneCurve", ImageMetaType.META_UNDEFINED);
        PentaxDirectory.add(1027, "ToneCurves", ImageMetaType.META_UNDEFINED);
        PentaxDirectory.add(25, "WhiteBalance", ImageMetaType.META_USHORT);
        PentaxDirectory.add(26, "WhiteBalanceMode", ImageMetaType.META_USHORT);
        PentaxDirectory.add(513, "WhitePoint", ImageMetaType.META_USHORT);
        PentaxDirectory.add(34, "WorldTimeLocation", ImageMetaType.META_USHORT);
    }
}

