/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.makernotes;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.image.metadata.makernotes.OlympusTags;
import com.lightcrafts.image.metadata.providers.PreviewImageProvider;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.image.types.ORFImageType;
import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class OlympusDirectory
extends MakerNotesDirectory
implements PreviewImageProvider {
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.makernotes.OlympusTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    @Override
    public int[] getMakerNotesAdjustments(LCByteBuffer buf, int offset) {
        return new int[]{8, offset};
    }

    @Override
    public String getName() {
        return "Olympus";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        return ORFImageType.INSTANCE.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public void putValue(Integer tagID, ImageMetaValue value) {
        switch (tagID) {
            case 1: 
            case 3: {
                this.explodeSubfields(tagID, 0, value, true);
                break;
            }
            case 4097: {
                float n = value.getFloatValue();
                value = new UnsignedShortMetaValue((int)(100.0 * Math.pow(2.0, n - 5.0f)));
                break;
            }
            case 4117: {
                int n;
                long[] v = ((LongMetaValue)value).getLongValues();
                switch (v.length) {
                    case 1: {
                        n = (int)v[0];
                        break;
                    }
                    case 2: {
                        n = (int)(v[0] * 10L + v[1]);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                value = new UnsignedShortMetaValue(n);
            }
        }
        super.putValue(tagID, value);
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        switch (value.getOwningTagID()) {
            case 4119: 
            case 4120: {
                return TextUtil.tenths(value.getFloatValue() / 256.0f);
            }
            case 13571: {
                String model = this.getOwningMetadata().getCameraMake(true);
                if (model != null && model.contains("E-1")) {
                    long[] n = ((LongMetaValue)value).getLongValues();
                    n[0] = n[0] - n[1];
                    n[2] = n[2] - n[1];
                    return n[0] + " (0," + n[2] + ')';
                }
            }
            case 13573: 
            case 13574: 
            case 13601: 
            case 13603: 
            case 13604: {
                String[] values = value.getValues();
                if (values.length != 3) {
                    return null;
                }
                return values[0] + " (" + values[1] + ',' + values[2] + ')';
            }
            case 13825: {
                if (value.getValueCount() != 2) break;
                int tagID = value.getOwningTagID();
                return this.getTagValueLabelFor(tagID, value.getIntValue()) + ", " + value.getValues()[1];
            }
            case 517: {
                return value.getStringValue() + "mm";
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return OlympusTags.class;
    }

    private static void add(int id, String name, ImageMetaType type) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, false);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    static {
        OlympusDirectory.add(4098, "Aperture", ImageMetaType.META_SRATIONAL);
        OlympusDirectory.add(515, "BlackAndWhiteMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(258, "BlackLevel", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4120, "BlueBalance", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4099, "Brightness", ImageMetaType.META_SRATIONAL);
        OlympusDirectory.add(521, "CameraID", ImageMetaType.META_UNKNOWN);
        OlympusDirectory.add(3, "CameraSettings", ImageMetaType.META_UNDEFINED);
        OlympusDirectory.add(1, "CameraSettingsOld", ImageMetaType.META_UNDEFINED);
        OlympusDirectory.add(519, "CameraType", ImageMetaType.META_UNKNOWN);
        OlympusDirectory.add(4153, "CCDScanMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(257, "ColorMode", ImageMetaType.META_ULONG);
        OlympusDirectory.add(64, "CompressedImageSize", ImageMetaType.META_ULONG);
        OlympusDirectory.add(4148, "CompressionRatio", ImageMetaType.META_URATIONAL);
        OlympusDirectory.add(4137, "Contrast", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4141, "CoringFilter", ImageMetaType.META_USHORT);
        OlympusDirectory.add(12544, "CSPreviewImageValid", ImageMetaType.META_ULONG);
        OlympusDirectory.add(12801, "CSAELock", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13060, "CSAFAreas", ImageMetaType.META_ULONG);
        OlympusDirectory.add(13059, "CSAFSearch", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13575, "CSColorspace", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13581, "CSCompressionFactor", ImageMetaType.META_URATIONAL);
        OlympusDirectory.add(13573, "CSContrastSetting", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(13571, "CSCustomSaturation", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(13579, "CSDistortionCorrection", ImageMetaType.META_USHORT);
        OlympusDirectory.add(12800, "CSExposureMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13313, "CSFlashExposureCompensation", ImageMetaType.META_SRATIONAL);
        OlympusDirectory.add(13312, "CSFlashMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13057, "CSFocusMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13058, "CSFocusProcess", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13583, "CSGradation", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13827, "CSImageQuality2", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13056, "CSMacroMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(12802, "CSMeteringMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13572, "CSModifiedSaturation", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13578, "CSNoiseReduction", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13825, "CSPanoramaMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13600, "CSPictureMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13605, "CSPMBWFilter", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(13603, "CSPMContrast", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(13602, "CSPMHue", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(13601, "CSPMSaturation", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(13604, "CSPMSharpness", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(13606, "CSPMTone", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(12546, "CSPreviewImageLength", ImageMetaType.META_ULONG);
        OlympusDirectory.add(12545, "CSPreviewImageStart", ImageMetaType.META_ULONG);
        OlympusDirectory.add(13577, "CSSceneMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13824, "CSSequence", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13580, "CSShadingCompensation", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13574, "CSSharpnessSetting", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(13568, "CSWhiteBalance", ImageMetaType.META_USHORT);
        OlympusDirectory.add(13570, "CSWhiteBalanceBracket", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(13569, "CSWhiteBalanceTemp", ImageMetaType.META_USHORT);
        OlympusDirectory.add(12288, "CSVersion", ImageMetaType.META_UNDEFINED);
        OlympusDirectory.add(516, "DigitalZoom", ImageMetaType.META_URATIONAL);
        OlympusDirectory.add(524, "EpsonImageHeight", ImageMetaType.META_USHORT);
        OlympusDirectory.add(523, "EpsonImageWidth", ImageMetaType.META_USHORT);
        OlympusDirectory.add(525, "EpsonSoftware", ImageMetaType.META_STRING);
        OlympusDirectory.add(4102, "ExposureCompensation", ImageMetaType.META_SRATIONAL);
        OlympusDirectory.add(4134, "ExternalFlashBounce", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4136, "ExternalFlashMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4135, "ExternalFlashZoom", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4112, "FlashChargeLevel", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4101, "FlashDevice", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4131, "FlashExposureCompensation", ImageMetaType.META_SRATIONAL);
        OlympusDirectory.add(4100, "FlashMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(517, "FocalPlaneDiagonal", ImageMetaType.META_URATIONAL);
        OlympusDirectory.add(4107, "FocusMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4110, "FocusStepCount", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4143, "ImageHeight", ImageMetaType.META_ULONG);
        OlympusDirectory.add(259, "ImageSize", ImageMetaType.META_ULONG);
        OlympusDirectory.add(4142, "ImageWidth", ImageMetaType.META_ULONG);
        OlympusDirectory.add(4155, "InfinityLensStep", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4097, "ISO", ImageMetaType.META_SRATIONAL);
        OlympusDirectory.add(518, "LensDistortionParams", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(4104, "LensTemperature", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(514, "MacroMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(0, "MakerNotesVersion", ImageMetaType.META_UNDEFINED);
        OlympusDirectory.add(4108, "ManualFocusDistance", ImageMetaType.META_URATIONAL);
        OlympusDirectory.add(4156, "NearLensStep", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4154, "NoiseReduction", ImageMetaType.META_USHORT);
        OlympusDirectory.add(770, "OneTouchWhiteBalance", ImageMetaType.META_USHORT);
        OlympusDirectory.add(137, "PreviewImageLength", ImageMetaType.META_ULONG);
        OlympusDirectory.add(4151, "PreviewImageLength2", ImageMetaType.META_ULONG);
        OlympusDirectory.add(136, "PreviewImageStart", ImageMetaType.META_ULONG);
        OlympusDirectory.add(4150, "PreviewImageStart2", ImageMetaType.META_ULONG);
        OlympusDirectory.add(4149, "PreviewImageValid", ImageMetaType.META_ULONG);
        OlympusDirectory.add(258, "Quality", ImageMetaType.META_USHORT);
        OlympusDirectory.add(259, "Quality2", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4119, "RedBalance", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4103, "SensorTemperature", ImageMetaType.META_SSHORT);
        OlympusDirectory.add(1028, "SerialNumber", ImageMetaType.META_STRING);
        OlympusDirectory.add(4122, "SerialNumber2", ImageMetaType.META_STRING);
        OlympusDirectory.add(4111, "Sharpness", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4138, "SharpnessFactor", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4096, "ShutterSpeed", ImageMetaType.META_SRATIONAL);
        OlympusDirectory.add(520, "TextInfo", ImageMetaType.META_UNDEFINED);
        OlympusDirectory.add(4117, "WhiteBalanceMode", ImageMetaType.META_USHORT);
        OlympusDirectory.add(4109, "ZoomStepCount", ImageMetaType.META_USHORT);
    }
}

