/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.makernotes;

import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.makernotes.KodakDirectory;
import com.lightcrafts.image.metadata.makernotes.MakerNoteProbe;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;

final class KodakMakerNoteProbe
extends MakerNoteProbe {
    static final MakerNoteProbe INSTANCE = new KodakMakerNoteProbe();
    private static final String[] m_models = new String[]{"CX6330", "CX7330", "CX7430", "CX7525", "CX7530", "DC4800", "DC4900", "DX3500", "DX3600", "DX3900", "DX4330", "DX4530", "DX4900", "DX6340", "DX6440", "DX6490", "DX7440", "DX7590", "DX7630", "EASYSHARE-ONE", "LS420", "LS443", "LS633", "LS743", "LS753", "Z700", "Z730", "Z740", "Z7560", "Z760"};

    @Override
    protected Class<? extends MakerNotesDirectory> match(ImageMetadata metadata) {
        if (KodakMakerNoteProbe.matchUsingMake(metadata, "KODAK", KodakDirectory.class) == null) {
            return null;
        }
        String cameraMakeModel = metadata.getCameraMake(true);
        for (String model : m_models) {
            if (!cameraMakeModel.contains(model)) continue;
            return KodakDirectory.class;
        }
        return null;
    }

    private KodakMakerNoteProbe() {
    }
}

