/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.makernotes;

import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.makernotes.FujiTags;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class FujiDirectory
extends MakerNotesDirectory {
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.makernotes.FujiTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    @Override
    public int[] getMakerNotesAdjustments(LCByteBuffer buf, int offset) {
        return new int[]{12, offset};
    }

    @Override
    public String getName() {
        return "Fuji";
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return FujiTags.class;
    }

    private static void add(int id, String name, ImageMetaType type) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, false);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    static {
        FujiDirectory.add(4352, "AutoBracketing", ImageMetaType.META_USHORT);
        FujiDirectory.add(4864, "BlurWarning", ImageMetaType.META_USHORT);
        FujiDirectory.add(4100, "Contrast", ImageMetaType.META_USHORT);
        FujiDirectory.add(4866, "ExposureWarning", ImageMetaType.META_USHORT);
        FujiDirectory.add(4112, "FlashMode", ImageMetaType.META_USHORT);
        FujiDirectory.add(4113, "FlashStrength", ImageMetaType.META_USHORT);
        FujiDirectory.add(4129, "FocusMode", ImageMetaType.META_USHORT);
        FujiDirectory.add(4865, "FocusWarning", ImageMetaType.META_USHORT);
        FujiDirectory.add(4128, "MacroMode", ImageMetaType.META_USHORT);
        FujiDirectory.add(4145, "PictureMode", ImageMetaType.META_USHORT);
        FujiDirectory.add(4096, "Quality", ImageMetaType.META_STRING);
        FujiDirectory.add(4099, "Saturation", ImageMetaType.META_USHORT);
        FujiDirectory.add(4097, "Sharpness", ImageMetaType.META_USHORT);
        FujiDirectory.add(4144, "SlowSync", ImageMetaType.META_USHORT);
        FujiDirectory.add(4098, "WhiteBalance", ImageMetaType.META_USHORT);
        FujiDirectory.add(0, "Version", ImageMetaType.META_UNDEFINED);
    }
}

