/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.values.ByteMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.UndefinedMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedByteMetaValue;
import com.lightcrafts.utils.xml.ElementFilter;
import com.lightcrafts.utils.xml.NodeTypeFilter;
import com.lightcrafts.utils.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XMPUtil {
    public static Document createEmptyXMPDocument(boolean includeXMPPacket) {
        StringBuilder s = new StringBuilder();
        if (includeXMPPacket) {
            s.append("<?xpacket begin='' id='W5M0MpCehiHzreSzNTczkc9d'?>");
        }
        s.append("<x:xmpmeta xmlns:x='adobe:ns:meta/'>\n  <rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'/>\n</x:xmpmeta>\n");
        if (includeXMPPacket) {
            s.append("<?xpacket end='w'?>");
        }
        return XMLUtil.readDocumentFrom(s.toString());
    }

    public static Element createRDFDescription(Document xmpDoc, String nsURI, String prefix) {
        Element rdfDescElement = xmpDoc.createElementNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf:Description");
        rdfDescElement.setAttribute("rdf:about", "");
        rdfDescElement.setAttribute("xmlns:" + prefix, nsURI);
        return rdfDescElement;
    }

    public static Element getLZNDescription(Element rdfElement, boolean create) {
        ElementFilter filter = new ElementFilter("rdf:Description", "xmlns:lzn", "http://www.lightcrafts.com/lightzone/LightZoneTransform");
        Element lznDescElement = (Element)XMLUtil.getFirstChildOf(rdfElement, filter);
        if (lznDescElement != null || !create) {
            return lznDescElement;
        }
        Document emptyLZNDoc = XMLUtil.readDocumentFrom("<rdf:Description rdf:about='' xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:lzn='http://www.lightcrafts.com/lightzone/LightZoneTransform'/>");
        lznDescElement = (Element)rdfElement.getOwnerDocument().importNode(emptyLZNDoc.getDocumentElement(), true);
        rdfElement.appendChild(lznDescElement);
        return lznDescElement;
    }

    public static Document getLZNDocumentFrom(Document xmpDoc) {
        Element rdfElement = XMPUtil.getRDFElementOf(xmpDoc);
        Element lznDescription = XMPUtil.getLZNDescription(rdfElement, false);
        if (lznDescription == null) {
            return null;
        }
        Element child = (Element)XMLUtil.getFirstChildOf(lznDescription, new NodeTypeFilter(1));
        if (child == null) {
            return null;
        }
        if (child.getLocalName().equals("xmpwrapper")) {
            Node lznNode = child.getFirstChild();
            if (lznNode == null) {
                return null;
            }
            String lznText = lznNode.getTextContent();
            if (lznText == null) {
                return null;
            }
            return XMLUtil.readDocumentFrom(lznText);
        }
        Document lznDoc = XMLUtil.createDocument();
        lznDoc.appendChild(lznDoc.importNode(child, true));
        return lznDoc;
    }

    public static Element getRDFElementOf(Document xmpDoc) {
        return (Element)XMLUtil.getFirstChildOf(xmpDoc.getDocumentElement(), new ElementFilter("rdf:RDF"));
    }

    public static byte[] getXMPDataFrom(ImageMetaValue value) {
        if (value instanceof UnsignedByteMetaValue) {
            return ((ByteMetaValue)value).getByteValues();
        }
        if (value instanceof UndefinedMetaValue) {
            return ((UndefinedMetaValue)value).getUndefinedValue();
        }
        return null;
    }

    public static Document mergeMetadata(Document newXMPDoc, Document oldXMPDoc) {
        XMPUtil.mergeMetadata(newXMPDoc, oldXMPDoc, "http://purl.org/dc/elements/1.1/", "dc");
        XMPUtil.mergeMetadata(newXMPDoc, oldXMPDoc, "http://ns.adobe.com/exif/1.0/", "exif");
        XMPUtil.mergeMetadata(newXMPDoc, oldXMPDoc, "http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/", "Iptc4xmpCore");
        XMPUtil.mergeMetadata(newXMPDoc, oldXMPDoc, "http://ns.adobe.com/tiff/1.0/", "tiff");
        XMPUtil.mergeMetadata(newXMPDoc, oldXMPDoc, "http://ns.adobe.com/xap/1.0/", "xap");
        return oldXMPDoc;
    }

    public static void mergeMetadata(Document newXMPDoc, Document oldXMPDoc, String dirNS, String dirPrefix) {
        Element newRDFElement = XMPUtil.getRDFElementOf(newXMPDoc);
        Element oldRDFElement = XMPUtil.getRDFElementOf(oldXMPDoc);
        ElementFilter dirFilter = new ElementFilter("rdf:Description", "xmlns:" + dirPrefix, dirNS);
        Node newRDFDirElement = XMLUtil.getFirstChildOf(newRDFElement, dirFilter);
        Element oldRDFDirElement = (Element)XMLUtil.getFirstChildOf(oldRDFElement, dirFilter);
        if (newRDFDirElement == null) {
            if (oldRDFDirElement != null) {
                Node parent = oldRDFDirElement.getParentNode();
                parent.removeChild(oldRDFDirElement);
            }
            return;
        }
        Document oldDocument = oldRDFElement.getOwnerDocument();
        newRDFDirElement = oldDocument.importNode(newRDFDirElement, true);
        if (oldRDFDirElement != null) {
            oldRDFElement.replaceChild(newRDFDirElement, oldRDFDirElement);
        } else {
            oldRDFElement.appendChild(newRDFDirElement);
        }
    }
}

