/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.TIFFTags;
import com.lightcrafts.image.metadata.providers.ApertureProvider;
import com.lightcrafts.image.metadata.providers.ArtistProvider;
import com.lightcrafts.image.metadata.providers.BitsPerChannelProvider;
import com.lightcrafts.image.metadata.providers.CaptionProvider;
import com.lightcrafts.image.metadata.providers.CaptureDateTimeProvider;
import com.lightcrafts.image.metadata.providers.CopyrightProvider;
import com.lightcrafts.image.metadata.providers.FlashProvider;
import com.lightcrafts.image.metadata.providers.MakeModelProvider;
import com.lightcrafts.image.metadata.providers.OrientationProvider;
import com.lightcrafts.image.metadata.providers.RatingProvider;
import com.lightcrafts.image.metadata.providers.ResolutionProvider;
import com.lightcrafts.image.metadata.providers.ShutterSpeedProvider;
import com.lightcrafts.image.metadata.providers.ThumbnailImageProvider;
import com.lightcrafts.image.metadata.providers.TitleProvider;
import com.lightcrafts.image.metadata.providers.WidthHeightProvider;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.RationalMetaValue;
import com.lightcrafts.image.types.JPEGImageType;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TIFFDirectory
extends ImageMetadataDirectory
implements ApertureProvider,
ArtistProvider,
BitsPerChannelProvider,
CaptionProvider,
CaptureDateTimeProvider,
CopyrightProvider,
FlashProvider,
MakeModelProvider,
OrientationProvider,
RatingProvider,
ResolutionProvider,
ShutterSpeedProvider,
ThumbnailImageProvider,
TitleProvider,
WidthHeightProvider {
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.TIFFTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    @Override
    public float getAperture() {
        ImageMetaValue value = this.getValue(33437);
        if (value == null) {
            value = this.getValue(37378);
        }
        if (!(value instanceof RationalMetaValue)) {
            return 0.0f;
        }
        return MetadataUtil.fixFStop(value.getFloatValue());
    }

    @Override
    public String getArtist() {
        ImageMetaValue value = this.getValue(315);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public int getBitsPerChannel() {
        ImageMetaValue value = this.getValue(258);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public String getCameraMake(boolean includeModel) {
        return this.getCameraMake(271, 272, includeModel);
    }

    @Override
    public String getCaption() {
        ImageMetaValue value = this.getValue(270);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public Date getCaptureDateTime() {
        ImageMetaValue value = this.getValue(306);
        return value instanceof DateMetaValue ? ((DateMetaValue)value).getDateValue() : null;
    }

    @Override
    public String getCopyright() {
        ImageMetaValue value = this.getValue(33432);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public String getFlash() {
        ImageMetaValue flashValue = this.getValue(37385);
        return TIFFDirectory.hasTagValueLabelFor(flashValue);
    }

    @Override
    public int getImageHeight() {
        ImageMetaValue value = this.getValue(257);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int getImageWidth() {
        ImageMetaValue value = this.getValue(256);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public String getName() {
        return "TIFF";
    }

    @Override
    public ImageOrientation getOrientation() {
        ImageMetaValue value = this.getValue(274);
        if (value != null) {
            try {
                return ImageOrientation.getOrientationFor(value.getIntValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ImageOrientation.ORIENTATION_UNKNOWN;
    }

    @Override
    public int getRating() {
        ImageMetaValue rating = this.getValue(18246);
        return rating != null ? rating.getIntValue() : 0;
    }

    @Override
    public double getResolution() {
        ImageMetaValue res = this.getValue(282);
        return res != null ? res.getDoubleValue() : 0.0;
    }

    @Override
    public int getResolutionUnit() {
        ImageMetaValue unit = this.getValue(296);
        if (unit != null) {
            switch (unit.getIntValue()) {
                case 3: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
            }
        }
        return 1;
    }

    @Override
    public float getShutterSpeed() {
        boolean isAPEX = false;
        ImageMetaValue value = this.getValue(33434);
        if (value == null) {
            value = this.getValue(37377);
            isAPEX = true;
        }
        if (!(value instanceof RationalMetaValue)) {
            return 0.0f;
        }
        if (isAPEX) {
            return EXIFDirectory.calcShutterSpeedFromAPEX(value);
        }
        return value.getFloatValue();
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        return JPEGImageType.getImageFromBuffer(imageInfo.getByteBuffer(), this.getValue(513), 0, this.getValue(514), 0, 0);
    }

    @Override
    public String getTitle() {
        ImageMetaValue value = this.getValue(269);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public Collection<Element> toXMP(Document xmpDoc) {
        return this.toXMP(xmpDoc, "http://ns.adobe.com/tiff/1.0/", "tiff");
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return TIFFTags.class;
    }

    private static void add(int id, String name, ImageMetaType type, boolean isChangeable) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, isChangeable);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    static {
        TIFFDirectory.add(37378, "ApertureValue", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(315, "Artist", ImageMetaType.META_STRING, true);
        TIFFDirectory.add(33423, "BatteryLevel", ImageMetaType.META_STRING, false);
        TIFFDirectory.add(258, "BitsPerSample", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(37379, "BrightnessValue", ImageMetaType.META_SRATIONAL, false);
        TIFFDirectory.add(265, "CellLength", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(264, "CellWidth", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(343, "ClipPath", ImageMetaType.META_UBYTE, false);
        TIFFDirectory.add(320, "ColorMap", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(259, "Compression", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(33432, "Copyright", ImageMetaType.META_STRING, true);
        TIFFDirectory.add(306, "DateTime", ImageMetaType.META_DATE, false);
        TIFFDirectory.add(269, "DocumentName", ImageMetaType.META_STRING, true);
        TIFFDirectory.add(336, "DotRange", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(34665, "EXIFIFDPointer", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(37380, "ExposureBiasValue", ImageMetaType.META_SRATIONAL, false);
        TIFFDirectory.add(34850, "ExposureProgram", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(37397, "ExposureIndex", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(33434, "ExposureTime", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(338, "ExtraSamples", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(266, "FillOrder", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(37385, "Flash", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(41483, "FlashEnergy", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(33437, "FNumber", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(289, "FreeByteCounts", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(288, "FreeOffsets", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(34853, "GPSInfoIfdPointer", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(291, "GrayResponseCurve", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(290, "GrayResponseUnit", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(321, "HalftoneHints", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(316, "HostComputer", ImageMetaType.META_STRING, false);
        TIFFDirectory.add(34675, "ICCProfile", ImageMetaType.META_UNDEFINED, false);
        TIFFDirectory.add(270, "ImageDescription", ImageMetaType.META_STRING, true);
        TIFFDirectory.add(37395, "ImageHistory", ImageMetaType.META_STRING, false);
        TIFFDirectory.add(32781, "ImageID", ImageMetaType.META_STRING, true);
        TIFFDirectory.add(257, "ImageLength", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(256, "ImageWidth", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(346, "Indexed", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(333, "InkNames", ImageMetaType.META_STRING, false);
        TIFFDirectory.add(332, "InkSet", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(521, "JPEGACTables", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(520, "JPEGDCTables", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(513, "JPEGInterchangeFormat", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(514, "JPEGInterchangeFormatLength", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(517, "JPEGLosslessPredictors", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(518, "JPEGPointTransforms", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(512, "JPEGProc", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(519, "JPEGQTables", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(515, "JPEGRestartInterval", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(37384, "LightSource", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(271, "Make", ImageMetaType.META_STRING, false);
        TIFFDirectory.add(37381, "MaxApertureValue", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(281, "MaxSampleValue", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(37383, "MeteringMode", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(280, "MinSampleValue", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(272, "Model", ImageMetaType.META_STRING, false);
        TIFFDirectory.add(18246, "MSRating", ImageMetaType.META_USHORT, true);
        TIFFDirectory.add(254, "NewSubfileType", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(334, "NumberOfInks", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(351, "OPIProxy", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(274, "Orientation", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(285, "PageName", ImageMetaType.META_STRING, false);
        TIFFDirectory.add(297, "PageNumber", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(262, "PhotometricInterpretation", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(34377, "PhotoshopImageResources", ImageMetaType.META_UBYTE, false);
        TIFFDirectory.add(284, "PlanarConfiguration", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(317, "Predictor", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(319, "PrimaryChromaticities", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(532, "ReferenceBlackWhite", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(296, "ResolutionUnit", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(33723, "RichTIFFIPTC", ImageMetaType.META_UNDEFINED, false);
        TIFFDirectory.add(278, "RowsPerStrip", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(339, "SampleFormat", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(277, "SamplesPerPixel", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(37394, "SecurityClassification", ImageMetaType.META_STRING, false);
        TIFFDirectory.add(37399, "SensingMethod", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(37377, "ShutterSpeedValue", ImageMetaType.META_SRATIONAL, false);
        TIFFDirectory.add(341, "SMaxSampleValue", ImageMetaType.META_SRATIONAL, false);
        TIFFDirectory.add(340, "SMinSampleValue", ImageMetaType.META_SRATIONAL, false);
        TIFFDirectory.add(305, "Software", ImageMetaType.META_STRING, false);
        TIFFDirectory.add(34852, "SpectralSensitivity", ImageMetaType.META_STRING, false);
        TIFFDirectory.add(279, "StripByteCounts", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(273, "StripOffsets", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(255, "SubfileType", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(330, "SubIFDs", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(37382, "SubjectDistance", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(37396, "SubjectLocation", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(292, "T4Options", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(293, "T6Options", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(337, "TargetPrinter", ImageMetaType.META_STRING, true);
        TIFFDirectory.add(263, "Threshholding", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(37398, "TIFFEPStandardID", ImageMetaType.META_UBYTE, false);
        TIFFDirectory.add(325, "TileByteCounts", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(323, "TileLength", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(324, "TileOffsets", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(322, "TileWidth", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(301, "TransferFunction", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(342, "TransferRange", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(318, "WhitePoint", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(344, "XClipPathUnits", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(700, "XMPPacket", ImageMetaType.META_UBYTE, false);
        TIFFDirectory.add(286, "XPosition", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(282, "XResolution", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(529, "YCbCrCoefficients", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(531, "YCbCrPositioning", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(530, "YCbCrSubSampling", ImageMetaType.META_USHORT, false);
        TIFFDirectory.add(345, "YClipPathUnits", ImageMetaType.META_ULONG, false);
        TIFFDirectory.add(287, "YPosition", ImageMetaType.META_URATIONAL, false);
        TIFFDirectory.add(283, "YResolution", ImageMetaType.META_URATIONAL, false);
    }
}

