/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.CIFFDirectory;
import com.lightcrafts.image.metadata.CoreDirectory;
import com.lightcrafts.image.metadata.DNGDirectory;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.IPTCDirectory;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.image.metadata.SubEXIFDirectory;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.XMPUtil;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.image.metadata.providers.ApertureProvider;
import com.lightcrafts.image.metadata.providers.ArtistProvider;
import com.lightcrafts.image.metadata.providers.BitsPerChannelProvider;
import com.lightcrafts.image.metadata.providers.CaptionProvider;
import com.lightcrafts.image.metadata.providers.CaptureDateTimeProvider;
import com.lightcrafts.image.metadata.providers.ColorTemperatureProvider;
import com.lightcrafts.image.metadata.providers.CopyrightProvider;
import com.lightcrafts.image.metadata.providers.FileDateTimeProvider;
import com.lightcrafts.image.metadata.providers.FlashProvider;
import com.lightcrafts.image.metadata.providers.FocalLengthProvider;
import com.lightcrafts.image.metadata.providers.ISOProvider;
import com.lightcrafts.image.metadata.providers.ImageMetadataProvider;
import com.lightcrafts.image.metadata.providers.LensProvider;
import com.lightcrafts.image.metadata.providers.MakeModelProvider;
import com.lightcrafts.image.metadata.providers.OrientationProvider;
import com.lightcrafts.image.metadata.providers.OriginalWidthHeightProvider;
import com.lightcrafts.image.metadata.providers.RatingProvider;
import com.lightcrafts.image.metadata.providers.ResolutionProvider;
import com.lightcrafts.image.metadata.providers.ShutterSpeedProvider;
import com.lightcrafts.image.metadata.providers.TitleProvider;
import com.lightcrafts.image.metadata.providers.WidthHeightProvider;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UndefinedMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedLongMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedRationalMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.utils.CollectionUtil;
import com.lightcrafts.utils.LightCraftsException;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.xml.XMLUtil;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImageMetadata
implements ApertureProvider,
BitsPerChannelProvider,
CaptionProvider,
CaptureDateTimeProvider,
Cloneable,
ColorTemperatureProvider,
CopyrightProvider,
Externalizable,
FileDateTimeProvider,
FlashProvider,
FocalLengthProvider,
ISOProvider,
LensProvider,
MakeModelProvider,
OrientationProvider,
OriginalWidthHeightProvider,
RatingProvider,
ResolutionProvider,
ShutterSpeedProvider,
TitleProvider,
WidthHeightProvider {
    private final Map<Class, ImageMetadataDirectory> m_classToDirMap = new HashMap<Class, ImageMetadataDirectory>();
    private ImageType m_imageType;

    public ImageMetadata() {
    }

    public ImageMetadata(ImageType imageType) {
        this.m_imageType = imageType;
    }

    public void clear() {
        this.m_classToDirMap.clear();
    }

    public void clearEdited() {
        for (ImageMetadataDirectory dir : this.m_classToDirMap.values()) {
            dir.clearEdited();
        }
    }

    public void clearRating() {
        this.setRating(0);
    }

    public Object clone() {
        ImageMetadata copy = new ImageMetadata(this.getImageType());
        for (Map.Entry<Class, ImageMetadataDirectory> me : this.m_classToDirMap.entrySet()) {
            Class dirClass = me.getKey();
            ImageMetadataDirectory dir = me.getValue();
            copy.m_classToDirMap.put(dirClass, dir.clone());
        }
        return copy;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImageMetadata) {
            ImageMetadata thatMD = (ImageMetadata)object;
            String thisPath = this.getPath();
            String thatPath = thatMD.getPath();
            return thisPath == null ? thatPath == null : thisPath.equals(thatPath);
        }
        return false;
    }

    public ImageMetadataDirectory findProviderOf(Class provider) {
        for (ImageMetadataDirectory dir : this.getDirectories()) {
            if (!provider.isInstance(dir)) continue;
            return dir;
        }
        return null;
    }

    public Collection<ImageMetadataDirectory> findProvidersOf(Class<? extends ImageMetadataProvider> provider) {
        ArrayList<ImageMetadataDirectory> providers = new ArrayList<ImageMetadataDirectory>();
        for (ImageMetadataDirectory dir : this.getDirectories()) {
            if (!provider.isInstance(dir)) continue;
            providers.add(dir);
        }
        Collections.sort(providers, new ProviderComparator(provider));
        return providers;
    }

    @Override
    public float getAperture() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(ApertureProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            float value = ((ApertureProvider)((Object)dir)).getAperture();
            if (!(value > 0.0f)) continue;
            return value;
        }
        return 0.0f;
    }

    public String getArtist() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(ArtistProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            String value = ((ArtistProvider)((Object)dir)).getArtist();
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public int getBitsPerChannel() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(BitsPerChannelProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            int value = ((BitsPerChannelProvider)((Object)dir)).getBitsPerChannel();
            if (value <= 0) continue;
            return value;
        }
        return 0;
    }

    @Override
    public final String getCameraMake(boolean includeModel) {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(MakeModelProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            String make = ((MakeModelProvider)((Object)dir)).getCameraMake(includeModel);
            if (make == null) continue;
            return make;
        }
        return null;
    }

    @Override
    public String getCaption() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(CaptionProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            String value = ((CaptionProvider)((Object)dir)).getCaption();
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public Date getCaptureDateTime() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(CaptureDateTimeProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            Date date = ((CaptureDateTimeProvider)((Object)dir)).getCaptureDateTime();
            if (date == null) continue;
            return date;
        }
        return null;
    }

    @Override
    public int getColorTemperature() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(ColorTemperatureProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            int temp = ((ColorTemperatureProvider)((Object)dir)).getColorTemperature();
            if (temp <= 0) continue;
            return temp;
        }
        return 0;
    }

    @Override
    public String getCopyright() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(CopyrightProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            String value = ((CopyrightProvider)((Object)dir)).getCopyright();
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public Collection<ImageMetadataDirectory> getDirectories() {
        return this.m_classToDirMap.values();
    }

    public ImageMetadataDirectory getDirectoryFor(Class<? extends ImageMetadataDirectory> dirClass) {
        return this.getDirectoryFor(dirClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageMetadataDirectory getDirectoryFor(Class<? extends ImageMetadataDirectory> dirClass, boolean create) {
        Map<Class, ImageMetadataDirectory> map = this.m_classToDirMap;
        synchronized (map) {
            ImageMetadataDirectory dir = this.m_classToDirMap.get(dirClass);
            if (dir == null && create) {
                try {
                    dir = dirClass.newInstance();
                    dir.setOwningMetadata(this);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                this.m_classToDirMap.put(dirClass, dir);
            }
            return dir;
        }
    }

    public File getFile() {
        String path = this.getPath();
        return path != null ? new File(path) : null;
    }

    @Override
    public Date getFileDateTime() {
        CoreDirectory dir = (CoreDirectory)this.getDirectoryFor(CoreDirectory.class);
        return dir != null ? dir.getFileDateTime() : null;
    }

    @Override
    public String getFlash() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(FlashProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            String flash = ((FlashProvider)((Object)dir)).getFlash();
            if (flash == null) continue;
            return flash;
        }
        return null;
    }

    @Override
    public float getFocalLength() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(FocalLengthProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            float value = ((FocalLengthProvider)((Object)dir)).getFocalLength();
            if (!(value > 0.0f)) continue;
            return value;
        }
        return 0.0f;
    }

    @Override
    public int getImageHeight() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(WidthHeightProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            int height = ((WidthHeightProvider)((Object)dir)).getImageHeight();
            if (height <= 0) continue;
            return height;
        }
        return 0;
    }

    public synchronized ImageType getImageType() {
        File file;
        if (this.m_imageType == null && (file = this.getFile()) != null) {
            ImageInfo info = ImageInfo.getInstanceFor(file);
            try {
                this.m_imageType = info.getImageType();
            }
            catch (IOException e) {
            }
            catch (LightCraftsException lightCraftsException) {
                // empty catch block
            }
        }
        return this.m_imageType;
    }

    @Override
    public int getImageWidth() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(WidthHeightProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            int width = ((WidthHeightProvider)((Object)dir)).getImageWidth();
            if (width <= 0) continue;
            return width;
        }
        return 0;
    }

    @Override
    public int getOriginalImageHeight() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(OriginalWidthHeightProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            int height = ((OriginalWidthHeightProvider)((Object)dir)).getOriginalImageHeight();
            if (height <= 0) continue;
            return height;
        }
        return 0;
    }

    @Override
    public int getOriginalImageWidth() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(OriginalWidthHeightProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            int width = ((OriginalWidthHeightProvider)((Object)dir)).getOriginalImageWidth();
            if (width <= 0) continue;
            return width;
        }
        return 0;
    }

    @Override
    public int getISO() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(ISOProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            int iso = ((ISOProvider)((Object)dir)).getISO();
            if (iso <= 0) continue;
            return iso;
        }
        return 0;
    }

    @Override
    public String getLens() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(LensProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            String lens = ((LensProvider)((Object)dir)).getLens();
            if (lens == null) continue;
            return lens;
        }
        return null;
    }

    @Override
    public ImageOrientation getOrientation() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(OrientationProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            ImageOrientation orientation = ((OrientationProvider)((Object)dir)).getOrientation();
            if (orientation == ImageOrientation.ORIENTATION_UNKNOWN) continue;
            return orientation;
        }
        return ImageOrientation.ORIENTATION_UNKNOWN;
    }

    public ImageOrientation getOriginalOrientation() {
        ImageMetaValue value = this.getValue(CoreDirectory.class, 517);
        return value != null ? ImageOrientation.getOrientationFor(value.getIntValue()) : ImageOrientation.ORIENTATION_LANDSCAPE;
    }

    public synchronized String getPath() {
        CoreDirectory coreDir = (CoreDirectory)this.getDirectoryFor(CoreDirectory.class);
        return coreDir != null ? coreDir.getPath() : null;
    }

    @Override
    public int getRating() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(RatingProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            int rating = ((RatingProvider)((Object)dir)).getRating();
            if (rating == 0) continue;
            return rating;
        }
        return 0;
    }

    @Override
    public double getResolution() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(ResolutionProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            double value = ((ResolutionProvider)((Object)dir)).getResolution();
            if (!(value > 0.0)) continue;
            return value;
        }
        return 0.0;
    }

    @Override
    public int getResolutionUnit() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(ResolutionProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            int value = ((ResolutionProvider)((Object)dir)).getResolutionUnit();
            if (value == 1) continue;
            return value;
        }
        return 1;
    }

    @Override
    public float getShutterSpeed() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(ShutterSpeedProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            float speed = ((ShutterSpeedProvider)((Object)dir)).getShutterSpeed();
            if (!(speed > 0.0f)) continue;
            return speed;
        }
        return 0.0f;
    }

    @Override
    public String getTitle() {
        Collection<ImageMetadataDirectory> dirs = this.findProvidersOf(TitleProvider.class);
        for (ImageMetadataDirectory dir : dirs) {
            String value = ((TitleProvider)((Object)dir)).getTitle();
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public ImageMetaValue getValue(Class<? extends ImageMetadataDirectory> dirClass, int tagID) {
        ImageMetadataDirectory dir = this.getDirectoryFor(dirClass);
        return dir != null ? dir.getValue(tagID) : null;
    }

    public int hashCode() {
        String path = this.getPath();
        return path != null ? path.hashCode() : super.hashCode();
    }

    public boolean isEmpty() {
        return this.m_classToDirMap.isEmpty();
    }

    public void mergeFrom(ImageMetadata fromMetadata) {
        for (ImageMetadataDirectory fromDir : fromMetadata.getDirectories()) {
            ImageMetadataDirectory toDir = this.getDirectoryFor(fromDir.getClass(), true);
            toDir.mergeFrom(fromDir);
        }
        ImageOrientation orientation = fromMetadata.getOrientation();
        if (orientation != ImageOrientation.ORIENTATION_UNKNOWN) {
            UnsignedShortMetaValue value = new UnsignedShortMetaValue(orientation.getTIFFConstant());
            this.putValue(EXIFDirectory.class, 274, value, false);
            this.putValue(TIFFDirectory.class, 274, value, false);
        }
    }

    public ImageMetadata prepForExport(ImageType exportImageType, boolean includeOrientation) {
        ImageMetaValue widthValue = this.getValue(CoreDirectory.class, 514);
        ImageMetaValue heightValue = this.getValue(CoreDirectory.class, 513);
        int width = widthValue != null ? widthValue.getIntValue() : 0;
        int height = heightValue != null ? heightValue.getIntValue() : 0;
        return this.prepForExport(exportImageType, width, height, (int)this.getResolution(), this.getResolutionUnit(), includeOrientation);
    }

    public ImageMetadata prepForExport(ImageType exportImageType, int imageWidth, int imageHeight, int resolution, int resolutionUnit, boolean includeOrientation) {
        ImageMetadataDirectory iptcDir;
        boolean toJPEG = exportImageType == JPEGImageType.INSTANCE;
        ImageMetadata metadata = (ImageMetadata)this.clone();
        ImageMetadataDirectory tiffDir = metadata.getDirectoryFor(TIFFDirectory.class);
        ImageMetadataDirectory ciffDir = metadata.getDirectoryFor(CIFFDirectory.class);
        if (ciffDir != null) {
            ImageMetadata ciffMetadata = ((CIFFDirectory)ciffDir).convertMetadata(toJPEG);
            metadata.mergeFrom(ciffMetadata);
            metadata.removeDirectory(CIFFDirectory.class);
        } else if (tiffDir == null) {
            tiffDir = metadata.getDirectoryFor(DNGDirectory.class);
        }
        ImageMetadataDirectory exifDir = metadata.getDirectoryFor(EXIFDirectory.class, true);
        if (toJPEG) {
            if (tiffDir != null) {
                ImageMetadataDirectory.moveValuesFromTo(tiffDir, exifDir);
            }
            tiffDir = exifDir;
        } else {
            ImageMetadataDirectory subEXIFDir;
            if (tiffDir == null) {
                tiffDir = metadata.getDirectoryFor(TIFFDirectory.class, true);
            }
            if ((subEXIFDir = metadata.getDirectoryFor(SubEXIFDirectory.class)) != null) {
                Iterator<Map.Entry<Integer, ImageMetaValue>> i = subEXIFDir.iterator();
                while (i.hasNext()) {
                    Map.Entry<Integer, ImageMetaValue> me = i.next();
                    exifDir.putValue(me.getKey(), me.getValue());
                }
                metadata.removeDirectory(SubEXIFDirectory.class);
            }
            ImageMetadataDirectory.moveValuesFromTo(exifDir, tiffDir);
        }
        exifDir.putValue(36864, new UndefinedMetaValue(EXIFDirectory.EXIF_VERSION));
        tiffDir.putValue(316, new StringMetaValue(System.getProperty("os.name") + ' ' + System.getProperty("os.version")));
        tiffDir.putValue(305, new StringMetaValue(Version.getApplicationName()));
        exifDir.removeValue(274);
        if (includeOrientation) {
            tiffDir.putValue(274, new UnsignedShortMetaValue(metadata.getOrientation().getTIFFConstant()));
        }
        exifDir.removeValue(18246);
        int rating = this.getRating();
        if (rating > 0) {
            tiffDir.putValue(18246, new UnsignedShortMetaValue(rating));
        } else {
            tiffDir.removeValue(18246);
        }
        exifDir.removeValue(40962);
        exifDir.removeValue(40963);
        if (imageWidth > 0 && imageHeight > 0) {
            UnsignedShortMetaValue widthValue = new UnsignedShortMetaValue(imageWidth);
            UnsignedShortMetaValue heightValue = new UnsignedShortMetaValue(imageHeight);
            tiffDir.putValue(256, widthValue);
            tiffDir.putValue(257, heightValue);
            if (exifDir != tiffDir) {
                widthValue = new UnsignedShortMetaValue(imageWidth);
                heightValue = new UnsignedShortMetaValue(imageHeight);
                exifDir.putValue(256, widthValue);
                exifDir.putValue(257, heightValue);
            }
        } else {
            tiffDir.removeValue(256);
            tiffDir.removeValue(257);
        }
        if (resolution > 0 && resolutionUnit != 1) {
            UnsignedRationalMetaValue xResolutionValue = new UnsignedRationalMetaValue(resolution, 1);
            UnsignedRationalMetaValue yResolutionValue = new UnsignedRationalMetaValue(resolution, 1);
            tiffDir.putValue(282, xResolutionValue);
            tiffDir.putValue(283, yResolutionValue);
            tiffDir.putValue(296, new UnsignedShortMetaValue(resolutionUnit));
        }
        if ((iptcDir = metadata.getDirectoryFor(IPTCDirectory.class)) != null) {
            int[][] iptcMap;
            for (int[] tagIDs : iptcMap = new int[][]{{592, 315}, {628, 33432}, {517, 269}, {632, 270}}) {
                ImageMetaValue value = iptcDir.getValue(tagIDs[0]);
                if (value == null) continue;
                tiffDir.putValue(tagIDs[1], value.clone());
            }
        }
        exifDir.removeValue(41730);
        exifDir.removeValue(37121);
        exifDir.removeValue(37122);
        exifDir.removeValue(34665);
        exifDir.removeValue(40965);
        exifDir.removeValue(513);
        exifDir.removeValue(514);
        exifDir.removeValue(37500);
        exifDir.removeValue(41484);
        exifDir.removeValue(37396);
        tiffDir.removeValue(265);
        tiffDir.removeValue(264);
        tiffDir.removeValue(343);
        tiffDir.removeValue(320);
        tiffDir.removeValue(259);
        tiffDir.removeValue(336);
        tiffDir.removeValue(338);
        tiffDir.removeValue(266);
        tiffDir.removeValue(289);
        tiffDir.removeValue(288);
        tiffDir.removeValue(291);
        tiffDir.removeValue(290);
        tiffDir.removeValue(321);
        tiffDir.removeValue(346);
        tiffDir.removeValue(521);
        tiffDir.removeValue(520);
        tiffDir.removeValue(513);
        tiffDir.removeValue(514);
        tiffDir.removeValue(517);
        tiffDir.removeValue(518);
        tiffDir.removeValue(512);
        tiffDir.removeValue(519);
        tiffDir.removeValue(515);
        tiffDir.removeValue(50919);
        tiffDir.removeValue(254);
        tiffDir.removeValue(351);
        tiffDir.removeValue(34377);
        tiffDir.removeValue(284);
        tiffDir.removeValue(317);
        tiffDir.removeValue(319);
        tiffDir.removeValue(532);
        tiffDir.removeValue(278);
        tiffDir.removeValue(339);
        tiffDir.removeValue(277);
        tiffDir.removeValue(279);
        tiffDir.removeValue(255);
        tiffDir.removeValue(273);
        tiffDir.removeValue(330);
        tiffDir.removeValue(292);
        tiffDir.removeValue(293);
        tiffDir.removeValue(263);
        tiffDir.removeValue(325);
        tiffDir.removeValue(324);
        tiffDir.removeValue(301);
        tiffDir.removeValue(342);
        tiffDir.removeValue(318);
        tiffDir.removeValue(344);
        tiffDir.removeValue(286);
        tiffDir.removeValue(529);
        tiffDir.removeValue(531);
        tiffDir.removeValue(530);
        tiffDir.removeValue(345);
        tiffDir.removeValue(287);
        if (toJPEG) {
            ImageMetadataDirectory subEXIFDir = null;
            Iterator<Map.Entry<Integer, ImageMetaValue>> i = exifDir.iterator();
            while (i.hasNext()) {
                Map.Entry<Integer, ImageMetaValue> me = i.next();
                int tagID = me.getKey();
                if (tagID == 34665 || tagID < 33434) continue;
                if (subEXIFDir == null) {
                    subEXIFDir = metadata.getDirectoryFor(SubEXIFDirectory.class, true);
                }
                subEXIFDir.putValue(tagID, me.getValue());
                i.remove();
            }
            if (subEXIFDir != null) {
                exifDir.putValue(34665, new UnsignedLongMetaValue(0L));
            }
            metadata.removeDirectory(TIFFDirectory.class);
        }
        metadata.removeDirectory(DNGDirectory.class);
        Iterator<ImageMetadataDirectory> i = metadata.getDirectories().iterator();
        while (i.hasNext()) {
            ImageMetadataDirectory dir = i.next();
            if (!(dir instanceof MakerNotesDirectory)) continue;
            i.remove();
        }
        CoreDirectory.syncEditableMetadata(metadata);
        CoreDirectory.syncImageDimensions(metadata);
        return metadata;
    }

    public ImageMetadata prepForXMP(boolean useActualOrientation) {
        ImageMetadata metadata = this.prepForExport(TIFFImageType.INSTANCE, false);
        metadata.removeValues(EXIFDirectory.class, 34665, 34853, 34675, 18246, 274, 330);
        metadata.removeValues(TIFFDirectory.class, 34665, 34853, 34675, 18246, 33723, 330, 700);
        ImageOrientation orientation = useActualOrientation ? metadata.getOrientation() : ImageOrientation.ORIENTATION_LANDSCAPE;
        metadata.putValue(TIFFDirectory.class, 274, new UnsignedShortMetaValue(orientation.getTIFFConstant()));
        return metadata;
    }

    public ImageMetadataDirectory putDirectory(ImageMetadataDirectory dir) {
        Class<?> dirClass = dir.getClass();
        return this.m_classToDirMap.put(dirClass, dir);
    }

    public boolean putValue(Class<? extends ImageMetadataDirectory> dirClass, int tagID, ImageMetaValue value) {
        return this.putValue(dirClass, tagID, value, true);
    }

    public boolean putValue(Class<? extends ImageMetadataDirectory> dirClass, int tagID, ImageMetaValue value, boolean create) {
        ImageMetadataDirectory dir = this.getDirectoryFor(dirClass, create);
        if (dir != null) {
            dir.putValue(tagID, value);
            return true;
        }
        return false;
    }

    public ImageMetadataDirectory removeDirectory(Class dirClass) {
        return this.m_classToDirMap.remove(dirClass);
    }

    public void removeAllEmptyDirectories() {
        Iterator<Map.Entry<Class, ImageMetadataDirectory>> i = this.m_classToDirMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Class, ImageMetadataDirectory> me = i.next();
            ImageMetadataDirectory dir = me.getValue();
            if (!dir.isEmpty()) continue;
            i.remove();
        }
    }

    public void removeAllEmptyStringValues() {
        for (ImageMetadataDirectory dir : this.m_classToDirMap.values()) {
            dir.removeAllEmptyStringValues();
        }
        CoreDirectory.syncEditableMetadata(this);
    }

    public void removeValues(Class<? extends ImageMetadataDirectory> dirClass, int ... tagIDs) {
        ImageMetadataDirectory dir = this.getDirectoryFor(dirClass);
        if (dir != null) {
            for (int tagID : tagIDs) {
                dir.removeValue(tagID);
            }
        }
    }

    public synchronized void setImageType(ImageType imageType) {
        this.m_imageType = imageType;
    }

    public void setOrientation(ImageOrientation orientation) {
        ImageMetadataDirectory dir = this.getDirectoryFor(CoreDirectory.class, true);
        dir.setValue((Integer)516, orientation.getTIFFConstant());
    }

    public void setRating(int rating) {
        if (rating < 0 || rating > 5) {
            throw new IllegalArgumentException("rating must be between 0-5");
        }
        ImageMetadataDirectory dir = this.getDirectoryFor(CoreDirectory.class, true);
        dir.setValue((Integer)518, rating);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ImageMetadataDirectory dir : this.getDirectories()) {
            sb.append(dir.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public Document toXMP(boolean useActualOrientation, boolean includeXMPPacket, Class<? extends ImageMetadataDirectory> ... dirClass) {
        ImageMetadata metadata = this.prepForXMP(useActualOrientation);
        Document doc = XMPUtil.createEmptyXMPDocument(includeXMPPacket);
        metadata.toXMP(doc, dirClass);
        return doc;
    }

    public void toXMP(Document xmpDoc, Class<? extends ImageMetadataDirectory> ... dirClass) {
        Set<Class<? extends ImageMetadataDirectory>> dirSet = CollectionUtil.asSet(dirClass);
        Element rdfElement = XMPUtil.getRDFElementOf(xmpDoc);
        for (ImageMetadataDirectory dir : this.getDirectories()) {
            Collection<Element> rdfDescElements;
            if (dirSet != null && !dirSet.isEmpty() && !dirSet.contains(dir.getClass()) || (rdfDescElements = dir.toXMP(xmpDoc)) == null) continue;
            for (Element element : rdfDescElements) {
                rdfElement.appendChild(element);
            }
        }
        Element dcRDFDescElement = this.toDublinCoreXMP(xmpDoc);
        if (dcRDFDescElement != null) {
            rdfElement.appendChild(dcRDFDescElement);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        for (int count = in.readShort(); count > 0; --count) {
            try {
                Class<?> dirClass = Class.forName(in.readUTF());
                this.getDirectoryFor(dirClass, true).readExternal(in);
                continue;
            }
            catch (ClassNotFoundException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.m_classToDirMap.size());
        for (Map.Entry<Class, ImageMetadataDirectory> me : this.m_classToDirMap.entrySet()) {
            Class dirClass = me.getKey();
            ImageMetadataDirectory dir = me.getValue();
            out.writeUTF(dirClass.getName());
            dir.writeExternal(out);
        }
    }

    private Element toDublinCoreXMP(Document xmpDoc) {
        String artist = this.getArtist();
        String description = this.getCaption();
        String rights = this.getCopyright();
        String title = this.getTitle();
        if (artist == null && description == null && rights == null && title == null) {
            return null;
        }
        Element dcRDFDescElement = XMPUtil.createRDFDescription(xmpDoc, "http://purl.org/dc/elements/1.1/", "dc");
        if (artist != null) {
            Element creatorElement = xmpDoc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:creator");
            XMLUtil.setTextContentOf(creatorElement, artist);
            dcRDFDescElement.appendChild(creatorElement);
        }
        if (description != null) {
            Element descriptionElement = xmpDoc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:description");
            XMLUtil.setTextContentOf(descriptionElement, description);
            dcRDFDescElement.appendChild(descriptionElement);
        }
        if (rights != null) {
            Element rightsElement = xmpDoc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:rights");
            XMLUtil.setTextContentOf(rightsElement, rights);
            dcRDFDescElement.appendChild(rightsElement);
        }
        if (title != null) {
            Element titleElement = xmpDoc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:title");
            XMLUtil.setTextContentOf(titleElement, title);
            dcRDFDescElement.appendChild(titleElement);
        }
        return dcRDFDescElement;
    }

    public static void main(String[] args) throws Exception {
        FileOutputStream fos = new FileOutputStream("/tmp/out");
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        ImageInfo info = ImageInfo.getInstanceFor(new File(args[0]));
        ImageMetadata metadata = info.getMetadata();
        metadata.writeExternal(oos);
        oos.close();
        fos.close();
        FileInputStream fis = new FileInputStream("/tmp/out");
        ObjectInputStream ois = new ObjectInputStream(fis);
        metadata = new ImageMetadata();
        metadata.readExternal(ois);
        ois.close();
        fis.close();
        System.out.println(metadata.toString());
    }

    private static final class ProviderComparator
    implements Comparator<ImageMetadataDirectory> {
        private final Class<? extends ImageMetadataProvider> m_provider;

        @Override
        public int compare(ImageMetadataDirectory dir1, ImageMetadataDirectory dir2) {
            return dir2.getProviderPriorityFor(this.m_provider) - dir1.getProviderPriorityFor(this.m_provider);
        }

        ProviderComparator(Class<? extends ImageMetadataProvider> provider) {
            this.m_provider = provider;
        }
    }
}

